/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.netscaler;

import com.google.common.base.Strings;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.netscaler.NetScalerItem;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerOrService
extends NetScalerItem {
    private final Container server;
    private int defaultShutdownDelay;
    private static final Logger logger = LoggerFactory.getLogger(ServerOrService.class);

    ServerOrService(Container container, int defaultShutdownDelay) {
        this.server = container;
        this.defaultShutdownDelay = defaultShutdownDelay;
    }

    @Override
    public int getDelay() {
        int serverTime = (Integer)this.server.getProperty("netscalerShutdownDelay");
        if (serverTime < 0) {
            return this.defaultShutdownDelay;
        }
        return serverTime;
    }

    @Override
    public String getDelayString() {
        return "" + this.getDelay();
    }

    @Override
    public String getAddress() {
        String serverAddress = (String)this.server.getProperty("netscalerAddress");
        if (!Strings.nullToEmpty((String)serverAddress).trim().isEmpty()) {
            return serverAddress;
        }
        if (this.server.getType().instanceOf(Type.valueOf(HostContainer.class))) {
            Host host = ((HostContainer)this.server).getHost();
            if (host.hasProperty("address")) {
                return (String)host.getProperty("address");
            }
            logger.info("Host {} has no address property, falling back to 'localhost'", (Object)host);
            return "localhost";
        }
        throw new IllegalStateException(String.format("Could not dermine netscaler Address for server [%s]", this.server));
    }

    @Override
    public String getNetScalerType() {
        return (String)this.server.getProperty("netscalerType");
    }

    public String toString() {
        return String.format("%s(%s)", this.getNetScalerType(), this.getAddress());
    }
}

