package com.xebialabs.deployit.plugin.netscaler;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import com.google.common.base.Strings;

import com.xebialabs.deployit.plugin.api.validation.Rule;
import com.xebialabs.deployit.plugin.api.validation.ValidationContext;
import com.xebialabs.deployit.plugin.api.validation.Validator;

@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
@Rule(clazz = NetScalerParametersValidator.Validator.class, type = "netScalerParametersValidator")
public @interface NetScalerParametersValidator {

    public static class Validator implements com.xebialabs.deployit.plugin.api.validation.Validator<NetScalerParameters> {

        @Override
        public void validate(NetScalerParameters value, ValidationContext context) {
            boolean serviceGroup = hasValue(value.getServiceGroup());
            boolean allServiceGroupFilled = serviceGroup && hasValue(value.getServiceGroupName()) && value.getServiceGroupPort() != null;

        }

        private boolean hasValue(String v) {
            return !Strings.nullToEmpty(v).trim().isEmpty();
        }
    }
}
