/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugins.lock;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugins.lock.LockCleanupListener;
import com.xebialabs.deployit.plugins.lock.TaskLockManager;
import com.xebialabs.deployit.repository.sql.lock.CiLockRepositoryHolder;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;

public class AcquireAllLocksStep
implements Step {
    private static final int ACQUIRE_LOCKS_ORDER = 2;
    private final Set<ConfigurationItem> cisToBeLocked;
    private final boolean enableRetry;
    private final int retryInSeconds;
    private final int retryLimit;

    public AcquireAllLocksStep(Set<ConfigurationItem> cisToBeLocked, boolean enableRetry, int retryInSeconds, int retryLimit) {
        this.cisToBeLocked = cisToBeLocked;
        this.enableRetry = enableRetry;
        this.retryInSeconds = retryInSeconds;
        this.retryLimit = retryLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StepExitCode execute(ExecutionContext context) throws Exception {
        ReentrantLock taskLock = TaskLockManager.getLock(context.getTask().getId());
        try {
            taskLock.lock();
            context.logOutput("Attempting to acquire locks on CIs " + this.cisToBeLocked);
            boolean locked = CiLockRepositoryHolder.getCiLockRepository().lock(this.cisToBeLocked, context.getTask().getId());
            if (!locked && this.enableRetry) {
                for (int retryCount = 0; !locked && retryCount < this.retryLimit; ++retryCount) {
                    context.logOutput("Will retry in " + this.retryInSeconds + " seconds");
                    Thread.sleep(this.retryInSeconds * 1000);
                    context.logOutput("Attempting to acquire locks on CIs " + this.cisToBeLocked);
                    locked = CiLockRepositoryHolder.getCiLockRepository().lock(this.cisToBeLocked, context.getTask().getId());
                }
            }
            if (locked) {
                context.logOutput("All locks acquired");
                context.setAttribute("lockCleanupListener", (Object)new LockCleanupListener(this.cisToBeLocked));
                StepExitCode stepExitCode = StepExitCode.SUCCESS;
                return stepExitCode;
            }
            context.logError("Failed to acquire one or more locks");
            StepExitCode stepExitCode = StepExitCode.PAUSE;
            return stepExitCode;
        }
        finally {
            taskLock.unlock();
        }
    }

    public String getDescription() {
        return "Acquiring locks for the following CIs: " + this.cisToBeLocked.toString();
    }

    public int getOrder() {
        return 2;
    }
}

