/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.lb.planning.orchestrator;

import com.google.common.base.Predicate;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.engine.spi.orchestration.Orchestration;
import com.xebialabs.deployit.engine.spi.orchestration.Orchestrations;
import com.xebialabs.deployit.engine.spi.orchestration.Orchestrator;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.plugin.api.udm.Environment;
import com.xebialabs.deployit.plugin.lb.ci.LoadBalancer;
import com.xebialabs.deployit.plugin.lb.planning.ContainerCollector;
import com.xebialabs.deployit.plugin.lb.planning.orchestrator.DisableServerInLoadBalancer;
import com.xebialabs.deployit.plugin.lb.planning.orchestrator.EnableServerInLoadBalancer;
import com.xebialabs.deployit.plugin.lb.planning.orchestrator.LoadBalancerComputedDeltas;
import com.xebialabs.deployit.plugin.lb.planning.orchestrator.LoadBalancerDeployed;
import com.xebialabs.deployit.plugin.lb.planning.orchestrator.ProcessedDelta;
import com.xebialabs.deployit.plugin.lb.util.Environments;
import com.xebialabs.deployit.plugin.lb.util.LoadBalancedContainers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Orchestrator.Metadata(name="sequential-by-loadbalancer-group", description="Creates serial orchestration around load balanced servers consisting of 3 sub orchestrations: 1. disable affected servers in load balancers, 2. do actual deployment, 3. enable affected servers in load balancers")
public class LoadBalancingOrchestrator
implements Orchestrator {
    private static final Type LOADBALANCER_TYPE = Type.valueOf(LoadBalancer.class);
    private static final Logger logger = LoggerFactory.getLogger(LoadBalancingOrchestrator.class);

    public Orchestration orchestrate(DeltaSpecification specification) {
        LoadBalancerComputedDeltas loadBalancerComputedDeltas = this.computeDeltas(specification);
        return Orchestrations.serial((String)this.descForAppDeployment(specification.getDeployedApplication()), (Orchestration[])new Orchestration[]{Orchestrations.interleaved((String)String.format("Disable %s containers in load balancers", loadBalancerComputedDeltas.getAffectedServerNameForDisable()), loadBalancerComputedDeltas.getDeltasForDisable()), Orchestrations.interleaved((String)String.format("Deploy on containers %s ", loadBalancerComputedDeltas.getPassedContainerNames()), loadBalancerComputedDeltas.getDeltasToPass()), Orchestrations.interleaved((String)String.format("Enable %s containers in load balancers", loadBalancerComputedDeltas.getAffectedServerNameForEnable()), loadBalancerComputedDeltas.getDeltasForEnable())});
    }

    protected LoadBalancerComputedDeltas computeDeltas(DeltaSpecification specification) {
        List deltas = specification.getDeltas();
        DeployedApplication deployedApplication = specification.getDeployedApplication();
        Environment targetEnvironment = deployedApplication.getEnvironment();
        Set<LoadBalancer> loadBalancers = Environments.getMembersOfType(targetEnvironment, LOADBALANCER_TYPE);
        Set<Container> containers = ContainerCollector.collectContainers(new Deltas(deltas), Container.class);
        ListMultimap<Container, LoadBalancer> affectedAppServers = LoadBalancedContainers.getContainerToLoadBalancersMap(loadBalancers, containers);
        logger.debug("App Servers affected by the deployment: {}", (Object)affectedAppServers.keySet());
        ListMultimap<Container, LoadBalancer> affectedWebServers = LoadBalancedContainers.getAffectedWebServers(loadBalancers, containers);
        logger.debug("Web Servers affected by the deployment: {}", (Object)affectedWebServers.keySet());
        ArrayListMultimap allAffectedServers = ArrayListMultimap.create(affectedAppServers);
        allAffectedServers.putAll(affectedWebServers);
        ArrayList<Delta> deltasToPass = new ArrayList<Delta>();
        LinkedListMultimap deployedsForDisablePerLoadBalancer = LinkedListMultimap.create();
        LinkedListMultimap deployedsForEnablePerLoadBalancer = LinkedListMultimap.create();
        for (Delta delta : deltas) {
            Container container = (Container)ContainerCollector.DELTA_CONTAINER_FUNCTION.apply((Object)delta);
            Delta deltaToPass = delta;
            if (null != container) {
                List affectedLoadBalancers = allAffectedServers.get((Object)container);
                Deltas deltasForContainer = new Deltas(this.deltasForContainer(deltas, container));
                for (LoadBalancer loadBalancer : affectedLoadBalancers) {
                    DisableServerInLoadBalancer deployedForDisable = new DisableServerInLoadBalancer(loadBalancer, container, deltasForContainer);
                    deployedsForDisablePerLoadBalancer.put((Object)loadBalancer, (Object)deployedForDisable);
                    EnableServerInLoadBalancer deployedForEnable = new EnableServerInLoadBalancer(loadBalancer, container, deltasForContainer);
                    deployedsForEnablePerLoadBalancer.put((Object)loadBalancer, (Object)deployedForEnable);
                }
                deltaToPass = this.markDeltaAsProcessed(delta);
            }
            deltasToPass.add(deltaToPass);
        }
        List<LoadBalancerDeployed> deployedsForDisable = this.reduceDeployedsPerLoadBalancer((ListMultimap<LoadBalancer, LoadBalancerDeployed>)deployedsForDisablePerLoadBalancer);
        List<LoadBalancerDeployed> deployedsForEnable = this.reduceDeployedsPerLoadBalancer((ListMultimap<LoadBalancer, LoadBalancerDeployed>)deployedsForEnablePerLoadBalancer);
        return new LoadBalancerComputedDeltas(deltasToPass, deployedsForDisable, deployedsForEnable);
    }

    private List<LoadBalancerDeployed> reduceDeployedsPerLoadBalancer(ListMultimap<LoadBalancer, LoadBalancerDeployed> deployedsPerLoadBalancer) {
        ArrayList<LoadBalancerDeployed> result = new ArrayList<LoadBalancerDeployed>();
        Map loadBalancerDeployeds = deployedsPerLoadBalancer.asMap();
        Set lbs = loadBalancerDeployeds.keySet();
        for (LoadBalancer loadBalancer : lbs) {
            Collection deployeds = (Collection)loadBalancerDeployeds.get((Object)loadBalancer);
            if (null == deployeds) continue;
            result.add(this.combineDeployeds(deployeds));
        }
        return result;
    }

    private LoadBalancerDeployed combineDeployeds(Collection<LoadBalancerDeployed> deployeds) {
        LoadBalancerDeployed result = null;
        Iterator<LoadBalancerDeployed> iterator = deployeds.iterator();
        if (iterator.hasNext()) {
            result = iterator.next();
            while (iterator.hasNext()) {
                LoadBalancerDeployed next = iterator.next();
                result.combine(next);
            }
        }
        return result;
    }

    protected String descForAppDeployment(DeployedApplication deployedApplication) {
        return String.format("Deploy application %s", deployedApplication.getName());
    }

    private Delta markDeltaAsProcessed(Delta delta) {
        return new ProcessedDelta(delta);
    }

    private List<Delta> deltasForContainer(List<Delta> deltas, final Container container) {
        return Lists.newArrayList((Iterable)FluentIterable.from(deltas).filter((Predicate)new Predicate<Delta>(){

            public boolean apply(Delta delta) {
                Container deltaContainer = (Container)ContainerCollector.DELTA_CONTAINER_FUNCTION.apply((Object)delta);
                return container.equals(deltaContainer);
            }
        }));
    }
}

