/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.lb.planning.orchestrator;

import com.xebialabs.deployit.engine.spi.orchestration.Orchestration;
import com.xebialabs.deployit.engine.spi.orchestration.Orchestrations;
import com.xebialabs.deployit.engine.spi.orchestration.Orchestrator;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.lb.ci.LoadBalancer;
import com.xebialabs.deployit.plugin.lb.planning.orchestrator.LoadBalancerComputedDeltas;
import com.xebialabs.deployit.plugin.lb.planning.orchestrator.LoadBalancingOrchestrator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Orchestrator.Metadata(name="sequential-by-loadbalancer-disable-group", description="Creates serial orchestration around load balanced servers consisting of 2 sub orchestrations: 1. disable affected servers in load balancers, 2. do actual deployment. ")
public class DisableInLoadBalancingOrchestrator
extends LoadBalancingOrchestrator {
    private static final Type LOADBALANCER_TYPE = Type.valueOf(LoadBalancer.class);
    private static final Logger logger = LoggerFactory.getLogger(DisableInLoadBalancingOrchestrator.class);

    @Override
    public Orchestration orchestrate(DeltaSpecification specification) {
        LoadBalancerComputedDeltas loadBalancerComputedDeltas = this.computeDeltas(specification);
        return Orchestrations.serial((String)this.descForAppDeployment(specification.getDeployedApplication()), (Orchestration[])new Orchestration[]{Orchestrations.interleaved((String)String.format("Disable %s containers in load balancers", loadBalancerComputedDeltas.getAffectedServerNameForDisable()), loadBalancerComputedDeltas.getDeltasForDisable()), Orchestrations.interleaved((String)String.format("Deploy on containers %s ", loadBalancerComputedDeltas.getPassedContainerNames()), loadBalancerComputedDeltas.getDeltasToPass())});
    }
}

