package com.xebialabs.deployit.plugin.lb.planning.orchestrator;

import java.util.*;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;

import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.lb.planning.ContainerCollector;

import static com.google.common.collect.FluentIterable.from;

public class LoadBalancerComputedDeltas {

    final List<Delta> deltasToPass;
    final List<LoadBalancerDeployed> deployedsForDisable;
    final List<LoadBalancerDeployed> deployedsForEnable;


    public LoadBalancerComputedDeltas(final List<Delta> deltasToPass, final List<LoadBalancerDeployed> deployedsForDisable, final List<LoadBalancerDeployed> deployedsForEnable) {
        this.deltasToPass = deltasToPass;
        this.deployedsForDisable = deployedsForDisable;
        this.deployedsForEnable = deployedsForEnable;
    }

    public List<Delta> getDeltasToPass() {
        return deltasToPass;
    }

    public List<Delta> getDeltasForDisable() {
        return deployedsToDeltas(deployedsForDisable);
    }

    public List<Delta> getDeltasForEnable() {
        return deployedsToDeltas(deployedsForEnable);
    }

    public List getAffectedServerNameForDisable() {
        return getAffectedServerNames(this.deployedsForDisable);
    }

    public List getAffectedServerNameForEnable() {
        return getAffectedServerNames(this.deployedsForEnable);
    }

    public List<String> getPassedContainerNames() {
        return from(ContainerCollector.collectContainers(new Deltas(deltasToPass), Container.class)).transform(new Function<Container, String>() {
            @Override
            public String apply(final Container input) {
                return input.getName();
            }
        }).toList();
    }

    private List getAffectedServerNames(final List<LoadBalancerDeployed> loadBalancerDeployeds) {
        Set<String> affectedServers = new HashSet<>();
        for (LoadBalancerDeployed loadBalancerDeployed : loadBalancerDeployeds) {
            for (Container container : loadBalancerDeployed.getAffectedServers()) {
                affectedServers.add(container.getName());
            }
        }
        List affectedServersList = new ArrayList(affectedServers);
        Collections.sort(affectedServersList);
        return affectedServersList;
    }


    private ImmutableList<Delta> deployedsToDeltas(List<LoadBalancerDeployed> deployeds) {
        return from(deployeds).transform(new Function<LoadBalancerDeployed, Delta>() {
            @Override
            public Delta apply(LoadBalancerDeployed deployed) {
                return new LoadBalancerDelta(deployed);
            }

            ;
        }).toList();
    }

}
