package com.xebialabs.deployit.plugin.lb.planning.orchestrator;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.xebialabs.deployit.engine.spi.orchestration.Orchestration;
import com.xebialabs.deployit.engine.spi.orchestration.Orchestrations;
import com.xebialabs.deployit.engine.spi.orchestration.Orchestrator;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.lb.ci.LoadBalancer;

import static com.xebialabs.deployit.engine.spi.orchestration.Orchestrations.interleaved;
import static java.lang.String.format;

@Orchestrator.Metadata(name = "sequential-by-loadbalancer-enable-group", description = "Creates serial orchestration around load balanced servers consisting of 2 sub orchestrations: " +
        "1. do actual deployment, 2. enable affected servers in load balancers")
public class EnableInLoadBalancingOrchestrator extends LoadBalancingOrchestrator {
    private static final Type LOADBALANCER_TYPE = Type.valueOf(LoadBalancer.class);

    @Override
    public Orchestration orchestrate(DeltaSpecification specification) {
        final LoadBalancerComputedDeltas loadBalancerComputedDeltas = computeDeltas(specification);
        return Orchestrations.serial(descForAppDeployment(specification.getDeployedApplication()),
                interleaved(format("Deploy on containers %s ", loadBalancerComputedDeltas.getPassedContainerNames()), loadBalancerComputedDeltas.getDeltasToPass()),
                interleaved(format("Enable %s containers in load balancers", loadBalancerComputedDeltas.getAffectedServerNameForEnable()), loadBalancerComputedDeltas.getDeltasForEnable())
        );
    }

    private static final Logger logger = LoggerFactory.getLogger(EnableInLoadBalancingOrchestrator.class);

}
