package com.xebialabs.deployit.plugin.lb.planning;

import java.util.Set;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;

import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Deployed;

import static com.google.common.base.Predicates.instanceOf;
import static com.google.common.base.Predicates.not;
import static com.google.common.collect.Iterables.filter;
import static com.google.common.collect.Iterables.transform;
import static com.xebialabs.deployit.plugin.lb.util.Predicates2.operationIs;

public class ContainerCollector {

    public static final Function<Delta, Container> DELTA_CONTAINER_FUNCTION = new Function<Delta, Container>() {
        @Override
        public Container apply(Delta input) {
            return getDeployed(input).getContainer();
        }

        private Deployed<?, ?> getDeployed(Delta delta) {
            return (delta.getOperation().equals(Operation.DESTROY)
                    ? delta.getPrevious()
                    : delta.getDeployed());
        }
    };

    public static <C extends Container> Set<C> collectContainers(Deltas deltas, Class<C> containerClass) {
        final Predicate<Object> isTargetContainerClass = instanceOf(containerClass);
        Iterable<Delta> nonNoopDeltas = filter(deltas.getDeltas(), not(operationIs(Operation.NOOP)));
        return (Set<C>) ImmutableSet.copyOf(filter(transform(nonNoopDeltas, DELTA_CONTAINER_FUNCTION), isTargetContainerClass));
    }
}
