/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.lb.planning;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.lb.util.Predicates2;
import java.util.Set;

public class ContainerCollector {
    private static final Function<Delta, Container> DELTA_CONTAINER_FUNCTION = new Function<Delta, Container>(){

        public Container apply(Delta input) {
            return this.getDeployed(input).getContainer();
        }

        private Deployed<?, ?> getDeployed(Delta delta) {
            return delta.getOperation().equals((Object)Operation.DESTROY) ? delta.getPrevious() : delta.getDeployed();
        }
    };

    public static <C extends Container> Set<C> collectContainers(Deltas deltas, Class<C> containerClass) {
        Predicate isTargetContainerClass = Predicates.instanceOf(containerClass);
        Iterable nonNoopDeltas = Iterables.filter((Iterable)deltas.getDeltas(), (Predicate)Predicates.not(Predicates2.operationIs(Operation.NOOP)));
        return ImmutableSet.copyOf((Iterable)Iterables.filter((Iterable)Iterables.transform((Iterable)nonNoopDeltas, DELTA_CONTAINER_FUNCTION), (Predicate)isTargetContainerClass));
    }
}

