package com.xebialabs.deployit.plugin.lb.ci;

import java.util.Set;

import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseContainer;
import com.xebialabs.deployit.plugin.overthere.HostContainer;

import static com.google.common.collect.Sets.newHashSet;

@Metadata(virtual = true, description = "The Load Balancer super type. ")
public abstract class LoadBalancer extends BaseContainer implements HostContainer {

    @Property(required = false)
    private Set<Container> managedServers = newHashSet();

    public abstract void stopTraffic(Deltas deltas, DeploymentPlanningContext ctx, Set<Container> serversToDisable);

    public abstract void startTraffic(Deltas deltas, DeploymentPlanningContext ctx, Set<Container> serversToEnable);

    public Set<Container> getManagedServers() {
        return managedServers;
    }

    public void setManagedServers(Set<Container> managedServers) {
        this.managedServers = managedServers;
    }
}
