package com.xebialabs.deployit.plugin.lb.util;

import com.xebialabs.deployit.plugin.api.udm.Container;

public class DeploymentGroups {
    private static final int UNALLOCATED_CONTAINER_GROUP = Integer.MAX_VALUE;
    public static final String DEPLOYMENT_GROUP_PROPERTY = "deploymentGroup";

    public static int getDeploymentGroup(Container container) {
        Integer deploymentGroup = container.<Integer>getProperty(DEPLOYMENT_GROUP_PROPERTY);
        return (deploymentGroup != null) ? deploymentGroup : UNALLOCATED_CONTAINER_GROUP;
    }
}
