/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.jbossdm.step;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;
import com.xebialabs.deployit.engine.spi.execution.ExecutionStateListener;
import com.xebialabs.deployit.engine.spi.execution.StepExecutionStateEvent;
import com.xebialabs.deployit.engine.spi.execution.TaskExecutionStateEvent;
import com.xebialabs.deployit.plugin.api.Deprecations;
import com.xebialabs.deployit.plugin.api.execution.ExecutionContextListener;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.jbossdm.io.TimedoutInputStreamReader;
import com.xebialabs.deployit.plugin.jbossdm.overthere.CmdLineUtil;
import com.xebialabs.deployit.plugin.jbossdm.step.CliProcessOutputHandler;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.OverthereProcess;
import com.xebialabs.overthere.OverthereProcessOutputHandler;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.util.OverthereUtils;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CliDaemon
implements ExecutionContextListener,
ExecutionStateListener,
Serializable {
    private String cliExecutable;
    private final String username;
    private final String password;
    private final String adminHost;
    private final int adminPort;
    private final Host connectingHost;
    private final int daemonConnectTimeout;
    private transient OverthereConnection connection;
    private transient OverthereProcess process;
    private static final int FLUSH_DELAY_MS = 5000;
    private static final int FLUSH_CHECK_INTERVAL_MS = 2000;
    private static final Logger logger = LoggerFactory.getLogger(CliDaemon.class);

    public CliDaemon(String cliExecutable, String username, String password, String adminHost, int adminPort, Host connectingHost) {
        this(cliExecutable, username, password, adminHost, adminPort, connectingHost, 0);
    }

    public CliDaemon(String cliExecutable, String username, String password, String adminHost, int adminPort, Host connectingHost, int daemonConnectTimeout) {
        this.cliExecutable = cliExecutable;
        this.username = username;
        this.password = password;
        this.adminHost = adminHost;
        this.adminPort = adminPort;
        this.connectingHost = connectingHost;
        this.daemonConnectTimeout = daemonConnectTimeout;
    }

    public Object executeCliCommandWithoutDaemon(ExecutionContext context, String cmd) {
        this.ensureConnection(context);
        CmdLine cmdLine = this.getCmdLine(cmd);
        List<Object> results = this.doExecute(cmdLine, cmdLine);
        if (results.isEmpty()) {
            throw new RuntimeException("Result looks empty");
        }
        return results.get(0);
    }

    public List<Object> executeCliCommandsWithoutDaemon(ExecutionContext context, String[] cmds) {
        this.ensureConnection(context);
        CmdLine cmdLine = this.getCmdLine(cmds);
        return this.doExecute(cmdLine, cmdLine);
    }

    public List<Object> executeCliCommandsWithoutDaemon(ExecutionContext context, CmdLine[] cmdLines) {
        this.ensureConnection(context);
        CmdLine executableCmdLine = this.getCmdLine(cmdLines, false);
        CmdLine loggablecmdLine = this.getCmdLine(cmdLines, true);
        return this.doExecute(executableCmdLine, loggablecmdLine);
    }

    public List<Object> executeCliCommandsWithoutDaemonViaFile(ExecutionContext context, String[] cmds) {
        return this.executeCliCommandsWithoutDaemonViaFile(context, CmdLineUtil.convertStringArrayToCmdLineArray(cmds));
    }

    public List<Object> executeCliCommandsWithoutDaemonViaFile(ExecutionContext context, CmdLine[] cmds) {
        this.ensureConnection(context);
        String LN = this.connection.getHostOperatingSystem().getLineSeparator();
        String loggablejoinedCmds = Joiner.on((String)LN).join((Object[])CmdLineUtil.convertCmdLineArrayToStringArray(cmds, true, this.connection));
        CmdLine cmdLine = this.getCmdLineForFile(Joiner.on((String)LN).join((Object[])CmdLineUtil.convertCmdLineArrayToStringArray(cmds, false, this.connection)), loggablejoinedCmds);
        return this.doExecute(cmdLine, cmdLine);
    }

    public Object executeCliCommand(ExecutionContext context, String cmd) {
        return this.executeCliCommand(context, new CmdLine().addRaw(cmd));
    }

    public Object executeCliCommand(ExecutionContext context, CmdLine cmd) {
        this.ensureConnection(context);
        CliProcessOutputHandler handler = this.getCliProcessOutputHandler();
        this.executeCommand(handler, cmd);
        return handler.getResult();
    }

    public List<Object> executeCliCommands(ExecutionContext context, String[] cmds) {
        Deprecations.deprecated((String)"Generic String commands deprecated. Please use com.xebialabs.overthere.CmdLine[] instead.", (Object[])new Object[0]);
        return this.executeCliCommands(context, CmdLineUtil.convertStringArrayToCmdLineArray(cmds));
    }

    public List<Object> executeCliCommands(ExecutionContext context, CmdLine[] cmds) {
        ArrayList results = Lists.newArrayList();
        for (CmdLine cmd : cmds) {
            Object result = this.executeCliCommand(context, cmd);
            results.add(result);
        }
        return results;
    }

    public void disconnect() {
        if (this.process != null) {
            this.process.destroy();
            this.process = null;
        }
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
    }

    public void connect(ExecutionContext context) {
        this.disconnect();
        this.connection = this.connectingHost.getConnection();
        CmdLine cmdLine = this.createBasicCliCmdLine();
        this.process = this.connection.startProcess(cmdLine);
        this.waitForCliStart(context);
    }

    public void contextDestroyed() {
        logger.debug("CLIDAEMON: ExecutionContext destroyed");
        this.disconnect();
    }

    public void stepStateChanged(StepExecutionStateEvent event) {
    }

    public boolean isAlive() {
        return this.connection != null;
    }

    public void taskStateChanged(TaskExecutionStateEvent event) {
        TaskExecutionState currentState = event.currentState();
        if (this.isAlive() && currentState.isPassiveAfterExecuting()) {
            logger.debug("CLIDAEMON: ExecutionContext destroyed");
            this.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForCliStart(final ExecutionContext context) {
        block17: {
            TimedoutInputStreamReader stdout = new TimedoutInputStreamReader(this.process.getStdout(), this.daemonConnectTimeout);
            final StringBuilder stdoutLineBuffer = new StringBuilder();
            final long[] flushAfter = new long[1];
            TimerTask flushTimerTask = new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    StringBuilder stringBuilder = stdoutLineBuffer;
                    synchronized (stringBuilder) {
                        if (flushAfter[0] < System.currentTimeMillis()) {
                            if (stdoutLineBuffer.length() > 0) {
                                context.logOutput(stdoutLineBuffer.toString());
                                stdoutLineBuffer.setLength(0);
                            }
                            flushAfter[0] = System.currentTimeMillis() + 5000L;
                        }
                    }
                }
            };
            new Timer("CliDaemon-AutoFlushTimer", true).schedule(flushTimerTask, 5000L, 2000L);
            while (true) {
                try {
                    StringBuilder stringBuilder;
                    char c;
                    do {
                        int cInt;
                        if ((cInt = ((InputStreamReader)stdout).read()) == -1) {
                            CliDaemon.captureStderr(context, this.process);
                            int exitCode = -1;
                            try {
                                exitCode = this.process.waitFor();
                            }
                            catch (InterruptedException exc) {
                                logger.error("Interrupted while waiting for " + this.process + " to complete");
                                Thread.currentThread().interrupt();
                            }
                            throw new RuntimeIOException("Cannot start cli: exit code " + exitCode);
                        }
                        c = (char)cInt;
                        if (c == '\r' || c == '\n') continue;
                        stringBuilder = stdoutLineBuffer;
                        synchronized (stringBuilder) {
                            stdoutLineBuffer.append(c);
                        }
                    } while (c != ']');
                    stringBuilder = stdoutLineBuffer;
                    synchronized (stringBuilder) {
                        flushAfter[0] = System.currentTimeMillis() + 5000L;
                        String stdoutLine = stdoutLineBuffer.toString();
                        stdoutLineBuffer.setLength(0);
                        if (stdoutLine.trim().matches("\\[(domain|standalone)@.+:[0-9]+./\\]")) {
                            break block17;
                        }
                        context.logOutput(stdoutLine);
                    }
                }
                catch (IOException exc) {
                    throw new RuntimeIOException("Cannot start cli due to " + exc.getMessage(), (Throwable)exc);
                }
            }
            finally {
                flushTimerTask.cancel();
            }
        }
    }

    private CmdLine getCmdLine(String cmd) {
        String[] cmds = new String[]{cmd};
        return this.getCmdLine(cmds);
    }

    private CmdLine getCmdLine(String[] cmds) {
        CmdLine cmdLine = this.createBasicCliCmdLine();
        return cmdLine.addArgument("--commands=" + Joiner.on((String)",").join((Object[])cmds));
    }

    private CmdLine getCmdLine(CmdLine[] cmdLines, boolean isLoggable) {
        return this.getCmdLine(CmdLineUtil.convertCmdLineArrayToStringArray(cmdLines, isLoggable, this.connection));
    }

    private CmdLine getCmdLineForFile(String commands, String loggableCommands) {
        CmdLine cmdLine = this.createBasicCliCmdLine();
        OverthereFile commandFile = this.connection.getTempFile("jboss-commands");
        OverthereUtils.write((String)commands, (String)"UTF-8", (OverthereFile)commandFile);
        logger.info("Executing commands {} from file {} on {} (without cli daemon)", new Object[]{loggableCommands, commandFile.getPath(), this.connection});
        return cmdLine.addArgument("--file=" + commandFile.getPath());
    }

    private List<Object> doExecute(CmdLine executableCmdLine, CmdLine loggablecmdLine) throws RuntimeIOException {
        logger.info("Executing commands {} on {} (without cli daemon)", (Object)loggablecmdLine.toString(), (Object)this.connection);
        CliProcessOutputHandler handler = this.getCliProcessOutputHandler();
        logger.debug("About to execute {}", (Object)loggablecmdLine.toString());
        int rc = this.connection.execute((OverthereProcessOutputHandler)handler, executableCmdLine);
        this.handleExecuteResponse(loggablecmdLine, handler, rc);
        return Lists.newArrayList((Object[])new Object[]{handler.getResult()});
    }

    private CliProcessOutputHandler getCliProcessOutputHandler() {
        return new CliProcessOutputHandler();
    }

    private void handleExecuteResponse(CmdLine cmdLine, CliProcessOutputHandler handler, int rc) throws RuntimeIOException {
        if (rc != 0) {
            String msg = String.format("Cli commands: '%s' failed with return code '%s'", cmdLine.toString(), rc);
            StringBuilder errMsg = new StringBuilder(msg);
            if (handler.hasErrors()) {
                errMsg.append(". Errors: ").append(handler.getErrors());
            }
            errMsg.append(". Details: ").append(handler.getResult());
            throw new RuntimeIOException(errMsg.toString());
        }
    }

    private boolean isConnected() {
        return this.connection != null && this.process != null;
    }

    private void ensureConnection(ExecutionContext context) {
        if (!this.isConnected()) {
            this.connect(context);
        }
    }

    private CmdLine createBasicCliCmdLine() {
        CmdLine cmdLine = new CmdLine();
        cmdLine.addArgument(this.cliExecutable).addArgument("--connect").addArgument("--controller=" + this.adminHost + ":" + this.adminPort);
        if (!Strings.nullToEmpty((String)this.username).trim().isEmpty()) {
            cmdLine.addArgument("--user=" + this.username);
        }
        if (!Strings.nullToEmpty((String)this.password).trim().isEmpty()) {
            cmdLine.addPassword("--password=" + this.password);
        }
        return cmdLine;
    }

    private static void captureStderr(ExecutionContext context, OverthereProcess daemonProcess) throws IOException {
        String stderrLine;
        BufferedReader stderr = new BufferedReader(new InputStreamReader(daemonProcess.getStderr()));
        while ((stderrLine = stderr.readLine()) != null) {
            context.logError(stderrLine);
        }
    }

    private void executeCommand(CliProcessOutputHandler handler, CmdLine command) {
        try {
            logger.info("Executing command {} on {} (with cli daemon)", (Object)command, (Object)this.connection);
            String executableCommandString = command.toCommandLine(this.connection.getHostOperatingSystem(), false);
            if (executableCommandString.charAt(executableCommandString.length() - 1) == '\n') {
                executableCommandString = executableCommandString.substring(0, executableCommandString.length() - 1);
            }
            String daemonLine = executableCommandString + "\n";
            OutputStream stdin = this.process.getStdin();
            stdin.write(daemonLine.getBytes());
            stdin.flush();
            InputStreamReader stdout = new InputStreamReader(this.process.getStdout());
            StringBuilder lineBuffer = new StringBuilder();
            while (true) {
                int iChar;
                if ((iChar = stdout.read()) == -1) {
                    throw new EOFException("Unexpected end of file");
                }
                char c = (char)iChar;
                if (c == '\r') continue;
                String line = lineBuffer.toString();
                if (c == '\n') {
                    if (!line.equals(executableCommandString) && !line.replaceAll("\\s", "").equals(executableCommandString.replaceAll("\\s", ""))) {
                        handler.handleOutputLine(line);
                    }
                    lineBuffer = new StringBuilder();
                    continue;
                }
                lineBuffer.append(c);
                if (!line.trim().matches("\\[(domain|standalone)@.+:[0-9]+\\s.*\\]")) {
                    handler.handleOutput(c);
                    continue;
                }
                break;
            }
        }
        catch (EOFException exc) {
            StringBuilder errMsg = new StringBuilder("Unexpected JBoss Cli termination when executing command ").append(command);
            if (handler.hasErrors()) {
                errMsg.append(". Errors: ").append(handler.getErrors());
            }
            errMsg.append(". Check that your Cli syntax is correct.");
            throw new RuntimeIOException(errMsg.toString(), (Throwable)exc);
        }
        catch (IOException exc) {
            StringBuilder errMsg = new StringBuilder("Cannot execute command: ").append(command);
            if (handler.hasErrors()) {
                errMsg.append(". Errors: ").append(handler.getErrors());
            }
            throw new RuntimeIOException(errMsg.toString(), (Throwable)exc);
        }
    }
}

