package com.xebialabs.deployit.plugin.jbossdm.deployed;

import java.util.ArrayList;
import java.util.List;

import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.udm.Deployed;

/**
* Created by ilx on 21.01.15..
*/
public class DeltaWrapper implements Delta {
    private Operation operation;
    private Deployed<?, ?> previous;
    private Deployed<?, ?> deployed;

    public DeltaWrapper() {}

    public DeltaWrapper(Delta delta) {
        this.operation = delta.getOperation();
        this.previous = delta.getPrevious();
        this.deployed = delta.getDeployed();
    }

    @Override
    public Operation getOperation() {
        return operation;
    }

    @Override
    public Deployed<?, ?> getPrevious() {
        return previous;
    }

    @Override
    public Deployed<?, ?> getDeployed() {
        return deployed;
    }

    @Override
    public List<String> getIntermediateCheckpoints() {
        return new ArrayList<>();
    }


}
