package com.xebialabs.deployit.plugin.jbossdm.step;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.codehaus.jackson.map.ObjectMapper;
import org.jboss.dmr.ModelNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;

import com.xebialabs.overthere.OverthereProcessOutputHandler;
import com.xebialabs.overthere.RuntimeIOException;

public class CliProcessOutputHandler implements OverthereProcessOutputHandler {

    private final List<String> lines = new ArrayList<>();
    private final List<String> errorLines = new ArrayList<>();

    @Override
    public void handleOutput(char c) {
    }

    @Override
    public void handleOutputLine(String line) {
        if (Strings.isNullOrEmpty(line)) {
            return;
        }
        lines.add(line);
    }

    @Override
    public void handleErrorLine(String line) {
        if (Strings.isNullOrEmpty(line)) {
            return;
        }
        this.errorLines.add(line);
    }

    public String getErrors() {
        return Joiner.on("\n").join(this.errorLines);
    }

    public boolean hasErrors() {
        return !errorLines.isEmpty();
    }

    public Object getResult() {
        if (lines.isEmpty()) {
            return null;
        }
        if (lines.get(0).startsWith("{") && lines.get(lines.size() - 1).endsWith("}")) {
            return parseAsMap();
        }

        return Joiner.on(" ").join(lines);
    }

    private Map<String, Object> parseAsMap() {
        String jbon = Joiner.on(" ").join(lines);
        logger.trace("JBON: " + jbon);
        String json = ModelNode.fromString(jbon).toJSONString(true);
        logger.trace("JSON: " + json);

        try {
            return new ObjectMapper().readValue(json, Map.class);
        } catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public String toString() {
        return "CliProcessOutputHandler{" +
            "values=" + lines +
            '}';
    }

    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
}