package com.xebialabs.deployit.plugin.jbossdm.controltask;

import java.util.Collections;
import java.util.List;
import java.util.Map;

import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.generic.step.ScriptExecutionStep;
import com.xebialabs.deployit.plugin.jbossdm.container.CliManagedContainer;
import com.xebialabs.deployit.plugin.jbossdm.deployed.CliManagedDeployed;

import static com.google.common.collect.Maps.newHashMap;
import static com.xebialabs.deployit.plugin.jbossdm.step.StepFactory.deploymentStepFactory;

public class ControlTaskDispatcher {

    private static final String SHELL_TASK = "ShellTaskScript";
    private static final String PYTHON_TASK = "PythonTaskScript";

    public static List<Step> dispatch(String name, ConfigurationItem item) {
        Map<String, Object> thisVarContext = newHashMap();
        CliManagedContainer container;
        if (item instanceof CliManagedContainer) {
            container = (CliManagedContainer) item;
            thisVarContext.put("container", container);
        } else if (item instanceof CliManagedDeployed) {
            container = ((CliManagedDeployed<?, ?>) item).getContainer();
            thisVarContext.put("container", container);
            thisVarContext.put("deployed", item);
        } else {
            throw new IllegalArgumentException(String.format("Control task '%s' can only be run against a CliManagedContainer or CliManagedDeployed. Configuration item '%s' is neither.", name, item));
        }

        if (item.hasProperty(name + SHELL_TASK)) {
            String scriptName = item.getProperty(name + SHELL_TASK);
            return Collections.<Step>singletonList(new ScriptExecutionStep(1, scriptName, container, thisVarContext, "Executing " + name));
        } else if (item.hasProperty(name + PYTHON_TASK)) {
            String scriptName = item.getProperty(name + PYTHON_TASK);
            return Collections.<Step>singletonList(deploymentStepFactory().createStep(scriptName, 1, thisVarContext, "Executing " + name, container));
        } else {
            throw new IllegalArgumentException(name + "PythonTaskScript or " + name + "ShellTaskScript property not found in " + item);
        }
    }

}
