package com.xebialabs.deployit.plugin.jbossdm.container;

import java.util.Map;

import com.xebialabs.deployit.plugin.api.inspection.Inspect;
import com.xebialabs.deployit.plugin.api.inspection.InspectionContext;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.jbossdm.step.CliInspectionStep;

import static com.google.common.collect.Maps.newHashMap;

@SuppressWarnings("serial")
@Metadata(description = "JBoss Standalone Server", inspectable = true)
public class StandaloneServer extends CliBasedContainer {

    @Inspect
    public void inspect(InspectionContext ctx) {
        Map<String, Object> pyCtx = newHashMap();
        pyCtx.put("container", this);
        CliInspectionStep step = new CliInspectionStep("jboss/dm/container/inspect-standalone-server.py", 0, pyCtx, "Inspect Standalone Server", this);
        ctx.addStep(step);
    }

    @Override
    public String getTargetServerGroup(boolean undeployment) {
        return "";
    }

    @Override
    public Mode getMode() {
        return Mode.STANDALONE;
    }
}
