/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.jbossdm.step;

import com.google.common.base.Strings;
import com.xebialabs.deployit.plugin.api.execution.ExecutionContextListener;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.jbossdm.step.CliProcessOutputHandler;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereProcess;
import com.xebialabs.overthere.OverthereProcessOutputHandler;
import com.xebialabs.overthere.RuntimeIOException;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CliDaemon
implements ExecutionContextListener,
Serializable {
    private String cliExecutable;
    private final String username;
    private final String password;
    private final String adminHost;
    private final int adminPort;
    private final Host connectingHost;
    private transient OverthereConnection connection;
    private transient OverthereProcess process;
    private static final int FLUSH_DELAY_MS = 5000;
    private static final int FLUSH_CHECK_INTERVAL_MS = 2000;
    private static final Logger logger = LoggerFactory.getLogger(CliDaemon.class);

    public CliDaemon(String cliExecutable, String username, String password, String adminHost, int adminPort, Host connectingHost) {
        this.cliExecutable = cliExecutable;
        this.username = username;
        this.password = password;
        this.adminHost = adminHost;
        this.adminPort = adminPort;
        this.connectingHost = connectingHost;
    }

    public Object executeCliCommandWithoutDaemon(ExecutionContext context, String cmd) {
        if (this.connection == null) {
            this.connection = this.connectingHost.getConnection();
        } else if (!this.isConnected()) {
            this.connect(context);
        }
        CmdLine cmdLine = this.createBasicCliCmdLine();
        cmdLine.addArgument("--command=" + cmd);
        CliProcessOutputHandler handler = new CliProcessOutputHandler();
        int rc = this.connection.execute((OverthereProcessOutputHandler)handler, cmdLine);
        if (rc != 0) {
            throw new RuntimeIOException("Cli command failed with return code " + rc + ". Details : " + handler.getResult());
        }
        return handler.getResult();
    }

    public Object executeCliCommand(ExecutionContext context, String cmd) {
        if (!this.isConnected()) {
            this.connect(context);
        }
        CliProcessOutputHandler handler = new CliProcessOutputHandler();
        this.executeCommand(handler, cmd);
        return handler.getResult();
    }

    private boolean isConnected() {
        return this.connection != null && this.process != null;
    }

    public void disconnect() {
        if (this.process != null) {
            this.process.destroy();
            this.process = null;
        }
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
    }

    public void connect(ExecutionContext context) {
        this.disconnect();
        this.connection = this.connectingHost.getConnection();
        CmdLine cmdLine = this.createBasicCliCmdLine();
        this.process = this.connection.startProcess(cmdLine);
        this.waitForCliStart(context);
    }

    private CmdLine createBasicCliCmdLine() {
        CmdLine cmdLine = new CmdLine();
        cmdLine.addArgument(this.cliExecutable).addArgument("--connect").addArgument("--controller=" + this.adminHost + ":" + this.adminPort);
        if (!Strings.nullToEmpty((String)this.username).trim().isEmpty()) {
            cmdLine.addArgument("--user=" + this.username);
        }
        if (!Strings.nullToEmpty((String)this.password).trim().isEmpty()) {
            cmdLine.addPassword("--password=" + this.password);
        }
        return cmdLine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForCliStart(final ExecutionContext context) {
        block17: {
            InputStreamReader stdout = new InputStreamReader(this.process.getStdout());
            final StringBuilder stdoutLineBuffer = new StringBuilder();
            final long[] flushAfter = new long[1];
            TimerTask flushTimerTask = new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    StringBuilder stringBuilder = stdoutLineBuffer;
                    synchronized (stringBuilder) {
                        if (flushAfter[0] < System.currentTimeMillis()) {
                            if (stdoutLineBuffer.length() > 0) {
                                context.logOutput(stdoutLineBuffer.toString());
                                stdoutLineBuffer.setLength(0);
                            }
                            flushAfter[0] = System.currentTimeMillis() + 5000L;
                        }
                    }
                }
            };
            new Timer("CliDaemon-AutoFlushTimer", true).schedule(flushTimerTask, 5000L, 2000L);
            while (true) {
                try {
                    StringBuilder stringBuilder;
                    char c;
                    do {
                        int cInt;
                        if ((cInt = stdout.read()) == -1) {
                            CliDaemon.captureStderr(context, this.process);
                            int exitCode = -1;
                            try {
                                exitCode = this.process.waitFor();
                            }
                            catch (InterruptedException exc) {
                                logger.error("Interrupted while waiting for " + this.process + " to complete");
                                Thread.currentThread().interrupt();
                            }
                            throw new RuntimeIOException("Cannot start cli: exit code " + exitCode);
                        }
                        c = (char)cInt;
                        if (c == '\r' || c == '\n') continue;
                        stringBuilder = stdoutLineBuffer;
                        synchronized (stringBuilder) {
                            stdoutLineBuffer.append(c);
                        }
                    } while (c != ']');
                    stringBuilder = stdoutLineBuffer;
                    synchronized (stringBuilder) {
                        flushAfter[0] = System.currentTimeMillis() + 5000L;
                        String stdoutLine = stdoutLineBuffer.toString();
                        stdoutLineBuffer.setLength(0);
                        if (stdoutLine.trim().matches("\\[(domain|standalone)@.+:[0-9]+./\\]")) {
                            break block17;
                        }
                        context.logOutput(stdoutLine);
                    }
                }
                catch (IOException exc) {
                    throw new RuntimeIOException("Cannot start cli", (Throwable)exc);
                }
            }
            finally {
                flushTimerTask.cancel();
            }
        }
    }

    private static void captureStderr(ExecutionContext context, OverthereProcess daemonProcess) throws IOException {
        String stderrLine;
        BufferedReader stderr = new BufferedReader(new InputStreamReader(daemonProcess.getStderr()));
        while ((stderrLine = stderr.readLine()) != null) {
            context.logError(stderrLine);
        }
    }

    private void executeCommand(CliProcessOutputHandler handler, String command) {
        try {
            logger.info("Executing command {} on {} (with cli daemon)", (Object)command, (Object)this.connection);
            if (command.charAt(command.length() - 1) == '\n') {
                command = command.substring(0, command.length() - 1);
            }
            String daemonLine = command + "\n";
            OutputStream stdin = this.process.getStdin();
            stdin.write(daemonLine.getBytes());
            stdin.flush();
            InputStreamReader stdout = new InputStreamReader(this.process.getStdout());
            StringBuilder lineBuffer = new StringBuilder();
            while (true) {
                char c;
                if ((c = (char)stdout.read()) == '\uffffffff') {
                    throw new EOFException("Unexpected end of file");
                }
                if (c == '\r') continue;
                String line = lineBuffer.toString();
                if (c == '\n') {
                    if (!line.equals(command)) {
                        handler.handleOutputLine(line);
                    }
                    lineBuffer = new StringBuilder();
                    continue;
                }
                lineBuffer.append(c);
                if (!line.trim().matches("\\[(domain|standalone)@.+:[0-9]+\\s.*\\]")) {
                    handler.handleOutput(c);
                    continue;
                }
                break;
            }
        }
        catch (IOException exc) {
            throw new RuntimeIOException("Cannot execute command " + command + " on " + this.connectingHost, (Throwable)exc);
        }
    }

    public void contextDestroyed() {
        this.disconnect();
    }
}

