/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.jbossdm.controltask;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.generic.step.ScriptExecutionStep;
import com.xebialabs.deployit.plugin.jbossdm.container.CliManagedContainer;
import com.xebialabs.deployit.plugin.jbossdm.deployed.CliManagedDeployed;
import com.xebialabs.deployit.plugin.jbossdm.step.CliDeploymentStep;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ControlTaskDispatcher {
    private static final String SHELL_TASK = "ShellTaskScript";
    private static final String PYTHON_TASK = "PythonTaskScript";

    public static List<Step> dispatch(String name, ConfigurationItem item) {
        CliManagedContainer container;
        HashMap thisVarContext = Maps.newHashMap();
        if (item instanceof CliManagedContainer) {
            container = (CliManagedContainer)item;
            thisVarContext.put("container", container);
        } else if (item instanceof CliManagedDeployed) {
            container = (CliManagedContainer)((CliManagedDeployed)item).getContainer();
            thisVarContext.put("container", container);
            thisVarContext.put("deployed", item);
        } else {
            throw new IllegalArgumentException(String.format("Control task '%s' can only be run against a CliManagedContainer or CliManagedDeployed. Configuration item '%s' is neither.", name, item));
        }
        if (item.hasProperty(name + SHELL_TASK)) {
            String scriptName = (String)item.getProperty(name + SHELL_TASK);
            return Collections.singletonList(new ScriptExecutionStep(1, scriptName, (HostContainer)container, (Map)thisVarContext, "Executing " + name));
        }
        if (item.hasProperty(name + PYTHON_TASK)) {
            String scriptName = (String)item.getProperty(name + PYTHON_TASK);
            return Collections.singletonList(new CliDeploymentStep(scriptName, 1, thisVarContext, "Executing " + name, container));
        }
        throw new IllegalArgumentException(name + "PythonTaskScript or " + name + "ShellTaskScript property not found in " + item);
    }
}

