package com.xebialabs.deployit.plugin.jbossdm.step;

import com.xebialabs.deployit.plugin.api.inspection.InspectionExecutionContext;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.jbossdm.container.CliManagedContainer;

import java.util.Map;

public class CliInspectionStep extends BaseStep<InspectionExecutionContext> {

	public CliInspectionStep(String script, int order, Map<String, Object> pythonContext, String description, CliManagedContainer container) {
		super(script, order, pythonContext, description, container);
	}

	@Override
	public Result execute(InspectionExecutionContext ctx) throws Exception {
        return handleExecute(ctx);
	}

    public ConfigurationItem discovered(String name, String type) {
        Descriptor descriptor = DescriptorRegistry.getDescriptor(type);
        ConfigurationItem item = descriptor.newInstance();
        item.setId(name);
        getCtx().discovered(item);
        return item;
    }


}
