package com.xebialabs.deployit.plugin.jbossdm.deployed;

import com.xebialabs.deployit.plugin.api.udm.DeployableArtifact;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifacts;
import com.xebialabs.deployit.plugin.api.udm.artifact.DerivedArtifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.PlaceholderReplacer;
import com.xebialabs.deployit.plugin.jbossdm.container.CliManagedContainer;
import com.xebialabs.overthere.OverthereFile;

import java.util.Map;

import static com.google.common.collect.Maps.newHashMap;

@Metadata(virtual = true, description = "Base for all deployed artifacts that utilize the JBoss Cli for configuration")
public class CliManagedDeployedArtifact<D extends DeployableArtifact,  C extends CliManagedContainer> extends CliManagedDeployed<D, C> implements DerivedArtifact<D> {

    private OverthereFile placeholderProcessedFile;

    @Property(description = "A Map containing all the placeholders mapped to their values. Special values are &lt;ignore&gt; or &lt;empty&gt;", required = false)
    private Map<String, String> placeholders = newHashMap();

    @Override
    public Map<String, String> getPlaceholders() {
        return placeholders;
    }

    @Override
    public void setPlaceholders(Map<String, String> placeholders) {
        this.placeholders = placeholders;
    }

    @Override
    public void initFile(PlaceholderReplacer replacer) {
        Artifacts.replacePlaceholders(this, replacer);
    }

    @Override
    public OverthereFile getFile() {
        return placeholderProcessedFile;
    }

    @Override
    public void setFile(OverthereFile file) {
        this.placeholderProcessedFile = file;
    }

    @Override
    public D getSourceArtifact() {
        return getDeployable();
    }

}
