package com.xebialabs.deployit.plugin.jbossdm.container;

import com.xebialabs.deployit.plugin.api.execution.ExecutionContext;
import com.xebialabs.deployit.plugin.api.inspection.Inspect;
import com.xebialabs.deployit.plugin.api.inspection.InspectionPlanningContext;
import com.xebialabs.deployit.plugin.api.inspection.InspectionProperty;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseContainer;
import com.xebialabs.deployit.plugin.jbossdm.step.CliDaemon;
import com.xebialabs.deployit.plugin.jbossdm.step.CliInspectionStep;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.overthere.OperatingSystemFamily;

import java.util.List;
import java.util.Map;

import static com.google.common.collect.Lists.newArrayList;
import static com.google.common.collect.Maps.newHashMap;

@Metadata(description = "JBoss Standalone Server")
public class StandaloneServer extends CliBasedContainer {

    @Inspect
    public void inspect(InspectionPlanningContext ctx) {
        Map<String,Object> pyCtx = newHashMap();
        pyCtx.put("container", this);
        CliInspectionStep step = new CliInspectionStep("jboss/dm/container/inspect-standalone-server.py", 0, pyCtx, "Inspect Standalone Server", this);
        ctx.addStep(step);
    }

    @Override
    public String getTargetServerGroup(boolean undeployment) {
        return "";
    }

    @Override
    public Mode getMode() {
        return Mode.STANDALONE;
    }
}
