from com.xebialabs.deployit.plugin.jbossdm.overthere import CustomCmdLine

@runBatch
def createDataSource(container, deployed):
    basicCommand = "xa-data-source --profile=%s add --name=%s" % (container.profile, deployed.name)
    cmdBuilder = CommandBuilder(deployed, CustomCmdLine().addRaw(basicCommand))
    mapCommonDatasourceProperties(cmdBuilder)
    cmdBuilder.addIfNotBlank('newConnectionSql', "--new-connection-sql")
    cmdBuilder.addIfNotBlank('transactionIsolation', "--transaction-isolation")
    cmdBuilder.add('sameRmOverride', "--same-rm-override")
    cmdBuilder.add('interleave', "--interleaving")
    cmdBuilder.add('padXid', "--pad-xid")
    cmdBuilder.add('wrapXa', "--wrap-xa-resource")

    logOutput("Creating datasource %s." % (deployed.name))
    executeCmd(cmdBuilder.cmd)

    logOutput("Setting datasource properties.")
    connProps = deployed.getProperty("xaProperties")
    connPropPath = "/subsystem=datasources/xa-data-source=%s/xa-datasource-properties" % (deployed.name)
    connPropPath = prependProfilePath(connPropPath)

    for key in connProps.keySet():
        addConnPropCmd = "%s=%s:add(value=%s)" % (connPropPath, key, connProps[key])
        executeCmd(CustomCmdLine().addRaw(addConnPropCmd))

validateDataSource(deployed)
createDataSource(container, deployed)

if True != isXaDataSourceEnabled(deployed.name):
    logOutput("Enabling datasource.")
    enableCmd = "/subsystem=datasources/xa-data-source=%s:enable" % (deployed.name)
    enableCmd = prependProfilePath(enableCmd)
    executeCmd(enableCmd)

logOutput("Done.")

