def getAppInstallName(name, type):
    ext = ".%s" % type
    if not name.endswith(ext):
        return name + ext
    return name

def undeploy(appName, serverGroup):
    errMsg = executeCmd("undeploy %s %s" % (appName, serverGroup))
    if errMsg:
        logErrorAndExit(errMsg)

def readDeploymentOnContainer(appName):
    if str(container.mode) == "DOMAIN":
        if str(container.type) == "jbossdm.ServerGroup":
            #Verify deployment exists for server group
            executeCmd("/server-group=%s/deployment=%s:read-resource()" %(container.name, appName))
        else:
            #Verify deployment exists on all  server groups in domain
            serverGroups = container.getProperty("serverGroups")
            for serverGroup in serverGroups:
                deployments = multiSpaceDelimitedLineToList(executeCmd("ls /server-group=%s/deployment" %(serverGroup.name)))
                if deployments.index(appName) == -1:
                    logErrorAndExit("Inspection cannot be executed because %s is not deployed to all server groups for domain %s. Thus the deployed cannot be targeted to a Domain but to specific server groups instead." %(appName,container.name))

    return executeCmd("/deployment=%s:read-resource()" %(appName))
