import re

if re.search(r"\s", deployed.name):
    logErrorAndExit("Deployed name must not contain space, but '%s' contains space." % (deployed.name))

# Configuration
# Leave the batch job on stopped state
executeCmd("/subsystem=batch-jberet:write-attribute(name=restart-jobs-on-resume,value=false)")

repositoryName = deployed.getProperty('defaultJobRepository')
# Add in-memory-job-repository
addRepoCmd = "/subsystem=batch-jberet/in-memory-job-repository=%s:add" % (repositoryName)

if deployed.getProperty('isJdbcRepository'):
    datasource = deployed.getProperty('datasource')
    addRepoCmd = "/subsystem=batch-jberet/jdbc-job-repository=%s:add(data-source=%s)" % (repositoryName, datasource)

executeCmd(addRepoCmd)

# Set a Default Job Repository:
setDefaultRepoCmd = "/subsystem=batch-jberet:write-attribute(name=default-job-repository,value=%s)" % (repositoryName)
executeCmd(setDefaultRepoCmd)
executeCmd("reload")

# # Configure a Thread Pool:
# # 1. Add a thread pool.
defaultThreadPool = deployed.getProperty('defaultThreadPool')
maxThreads = deployed.getProperty('maxThreads')
threadPoolCmd = "/subsystem=batch-jberet/thread-pool=%s:add(max-threads=%s)" % (defaultThreadPool, maxThreads)
executeCmd(threadPoolCmd)
executeCmd("reload")

#Set default-thread pool
setDefaultThreadPoolCmd = "/subsystem=batch-jberet:write-attribute(name=default-thread-pool,value=%s)" % (defaultThreadPool)
executeCmd(setDefaultThreadPoolCmd)
executeCmd("reload")

# # 2. If desired, set a keepalive-time value.
keepaliveTime = deployed.getProperty('keepaliveTime')
addKeepaliveTimeCmd = "/subsystem=batch-jberet/thread-pool=%s:write-attribute(name=keepalive-time,value={time=%s,unit=SECONDS})" % (defaultThreadPool, keepaliveTime)
executeCmd(addKeepaliveTimeCmd)
executeCmd("reload")

# Get statistics of thread-pool
getThreadPoolStat = "/subsystem=batch-jberet/thread-pool=%s:read-resource(include-runtime=true)" % (defaultThreadPool)
getThreadPoolStat = executeCmd(getThreadPoolStat)
logOutput("Thread Pool Statistics: %s" % (getThreadPoolStat))

# Deploy the jberet application
appName = getAppInstallName(deployed.name, "war")
uploadedWar = uploadFile(deployed.file, appName)
logOutput("Installing batch application as %s" % (appName))

commandString = 'deploy %s %s' % (uploadedWar.path, targetServerGroups())
executeCmd(commandString)

# Start batch job
deploymentName = deployed.getProperty('deploymentName')
jobXmlName = deployed.getProperty('jobXmlName')

propertyStr = ""
properties = deployed.getProperty('properties')
for property in properties:
    print(property,':', properties[property])
    if len(propertyStr) == 0:
        propertyStr += property + '=' + properties[property]
    else:
        propertyStr += ',' + property + '=' + properties[property]
print(propertyStr)

startBatchJobCmd = "/deployment=%s.war/subsystem=batch-jberet:start-job(job-xml-name=%s,properties={%s})" % (deploymentName, jobXmlName, propertyStr)
executeCmd(startBatchJobCmd)

batchJobExecutionDetails = "/deployment=%s.war/subsystem=batch-jberet:read-resource(recursive=true,include-runtime=true)" % (deploymentName)
batchJobExecutionDetails = executeCmd(batchJobExecutionDetails)

logOutput("Batch Job Execution Details: %s" %(batchJobExecutionDetails))
logOutput("Done.")





