appName = deployed.name
logOutput("Uninstalling application %s" % (appName))
undeploy(appName, targetServerGroups(True))
logOutput("%s application is undeployed" %(appName))

#Start batching commands
executeCmd("batch")

logOutput("Removing the application logger")
executeCmd("/subsystem=logging/logger=org.jboss.as.%s.logging:remove" %(appName))
logOutput("Application logger is removed.")

logOutput("Removing the log async handler")
executeCmd("/subsystem=logging/async-handler=TRACE_%s_ASYNC:remove" %(appName))
executeCmd("/subsystem=logging/async-handler=DEBUG_%s_ASYNC:remove" %(appName))
executeCmd("/subsystem=logging/async-handler=INFO_%s_ASYNC:remove" %(appName))
executeCmd("/subsystem=logging/async-handler=WARN_%s_ASYNC:remove" %(appName))
executeCmd("/subsystem=logging/async-handler=ERROR_%s_ASYNC:remove" %(appName))
executeCmd("/subsystem=logging/async-handler=FATAL_%s_ASYNC:remove" %(appName))
logOutput("Log async handlers are removed.")

logOutput("Removing the file handlers")
executeCmd("/subsystem=logging/periodic-rotating-file-handler=FILE_%s_TRACE:remove" %(appName))
executeCmd("/subsystem=logging/periodic-rotating-file-handler=FILE_%s_DEBUG:remove" %(appName))
executeCmd("/subsystem=logging/periodic-rotating-file-handler=FILE_%s_INFO:remove" %(appName))
executeCmd("/subsystem=logging/periodic-rotating-file-handler=FILE_%s_WARN:remove" %(appName))
executeCmd("/subsystem=logging/periodic-rotating-file-handler=FILE_%s_ERROR:remove" %(appName))
executeCmd("/subsystem=logging/periodic-rotating-file-handler=FILE_%s_FATAL:remove" %(appName))
logOutput("File handlers are removed")

# Run the batch commands
executeCmd("run-batch")

# Reload the server configuration
executeCmd("reload")
logOutput("Done.")
