import re

if re.search(r"\s", deployed.name):
    logErrorAndExit("Deployed name must not contain space, but '%s' contains space." % (deployed.name))

# Deploy the application
appName = deployed.name
uploadedWar = uploadFile(deployed.file, appName)
logOutput("Installing %s application with logging enabled" % (appName))

suffix = '".yyyy.MM.dd"'
path = '"path"'
file_relative_to = '"relative-to"'
comma = '"'

# Add the logging subsystem.
executeCmd("/subsystem=logging:write-attribute(name=add-logging-api-dependencies, value=true)")
executeCmd("/subsystem=logging:write-attribute(name=use-deployment-logging-config, value=true)")

# Start batching commands
executeCmd("batch")
commandString = 'deploy %s %s --disabled' % (uploadedWar.path, targetServerGroups())
executeCmd(commandString)
executeCmd("reload")
logOutput("Application %s deployed" % (appName))

logOutput("Adding the periodic rotating file handlers corresponding to those added to the logging properties file")
executeCmd("/subsystem=logging/periodic-rotating-file-handler=FILE_%s_TRACE:add(suffix=%s, file={%s=>%s%s.trace.log%s, %s=>%sjboss.server.log.dir%s})" %(appName, suffix, path, comma, appName, comma, file_relative_to, comma, comma))
executeCmd("/subsystem=logging/periodic-rotating-file-handler=FILE_%s_DEBUG:add(suffix=%s, file={%s=>%s%s.debug.log%s, %s=>%sjboss.server.log.dir%s})" %(appName, suffix, path, comma, appName, comma, file_relative_to, comma, comma))
executeCmd("/subsystem=logging/periodic-rotating-file-handler=FILE_%s_INFO:add(suffix=%s, file={%s=>%s%s.info.log%s, %s=>%sjboss.server.log.dir%s})" %(appName, suffix, path, comma, appName, comma, file_relative_to, comma, comma))
executeCmd("/subsystem=logging/periodic-rotating-file-handler=FILE_%s_WARN:add(suffix=%s, file={%s=>%s%s.warn.log%s, %s=>%sjboss.server.log.dir%s})" %(appName, suffix, path, comma, appName, comma, file_relative_to, comma, comma))
executeCmd("/subsystem=logging/periodic-rotating-file-handler=FILE_%s_ERROR:add(suffix=%s, file={%s=>%s%s.error.log%s, %s=>%sjboss.server.log.dir%s})" %(appName, suffix, path, comma, appName, comma, file_relative_to, comma, comma))
executeCmd("/subsystem=logging/periodic-rotating-file-handler=FILE_%s_FATAL:add(suffix=%s, file={%s=>%s%s.fatal.log%s, %s=>%sjboss.server.log.dir%s})" %(appName, suffix, path, comma, appName, comma, file_relative_to, comma, comma))
logOutput("Periodic rotating file handlers is added.")

logOutput("Configuring the logging async handlers")
executeCmd("/subsystem=logging/async-handler=TRACE_%s_ASYNC:add(level=TRACE,queue-length=1024,overflow-action=BLOCK,subhandlers=[%sFILE_%s_TRACE%s])" %(appName, comma, appName, comma))
executeCmd("/subsystem=logging/async-handler=DEBUG_%s_ASYNC:add(level=DEBUG,queue-length=1024,overflow-action=BLOCK,subhandlers=[%sFILE_%s_DEBUG%s])" %(appName, comma, appName, comma))
executeCmd("/subsystem=logging/async-handler=INFO_%s_ASYNC:add(level=INFO,queue-length=1024,overflow-action=BLOCK,subhandlers=[%sFILE_%s_INFO%s])" %(appName, comma, appName, comma))
executeCmd("/subsystem=logging/async-handler=WARN_%s_ASYNC:add(level=WARN,queue-length=1024,overflow-action=BLOCK,subhandlers=[%sFILE_%s_WARN%s])" %(appName, comma, appName, comma))
executeCmd("/subsystem=logging/async-handler=ERROR_%s_ASYNC:add(level=ERROR,queue-length=1024,overflow-action=BLOCK,subhandlers=[%sFILE_%s_ERROR%s])" %(appName, comma, appName, comma))
executeCmd("/subsystem=logging/async-handler=FATAL_%s_ASYNC:add(level=FATAL,queue-length=1024,overflow-action=BLOCK,subhandlers=[%sFILE_%s_FATAL%s])" %(appName, comma, appName, comma))
logOutput("Logging async handlers are Configured.")

logOutput("Creating the logger for application")
### NOTE: To view different logging levels, change the level below from TRACE to DEBUG, INFO, WARN, ERROR, or FATAL, then access the application.
executeCmd("/subsystem=logging/logger=org.jboss.as.%s.logging:add(level=TRACE,handlers=[TRACE_%s_ASYNC,DEBUG_%s_ASYNC,INFO_%s_ASYNC,WARN_%s_ASYNC,ERROR_%s_ASYNC,FATAL_%s_ASYNC])" %(appName, appName, appName, appName, appName, appName, appName))
logOutput("Created the logger for application.")

# Run the batch commands
executeCmd("run-batch")
executeCmd("reload")
logOutput("Done.")
