/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.jbossdm.step;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Preview;
import com.xebialabs.deployit.plugin.api.flow.PreviewStep;
import com.xebialabs.deployit.plugin.api.flow.StageableStep;
import com.xebialabs.deployit.plugin.api.flow.StagedFile;
import com.xebialabs.deployit.plugin.api.flow.StagingContext;
import com.xebialabs.deployit.plugin.api.flow.StagingTarget;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.rules.RulePostConstruct;
import com.xebialabs.deployit.plugin.api.rules.StepMetadata;
import com.xebialabs.deployit.plugin.api.rules.StepParameter;
import com.xebialabs.deployit.plugin.api.rules.StepPostConstructContext;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.jbossdm.container.CliManagedContainer;
import com.xebialabs.deployit.plugin.jbossdm.step.BaseStep;
import com.xebialabs.deployit.plugin.jbossdm.step.CliDeploymentStep;
import com.xebialabs.deployit.plugin.jbossdm.step.JustInTimeFile;
import com.xebialabs.deployit.plugin.steps.CalculatedStep;
import com.xebialabs.deployit.plugin.steps.ContextHelper;
import com.xebialabs.deployit.plugin.steps.TargetContainerJavaHelper;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@StepMetadata(name="jboss-cli")
public class JbossCliStep
extends CalculatedStep
implements PreviewStep,
StageableStep {
    protected static final Logger logger = LoggerFactory.getLogger(JbossCliStep.class);
    public static final String AUTO_UPLOAD = "_AUTO_UPLOAD";
    @StepParameter(description="Path to the python script to be executed.")
    private String script;
    @StepParameter(description="Dictionary that represent context available to the python script", required=false, calculated=true)
    private Map<String, Object> pythonContext = new HashMap<String, Object>();
    @StepParameter(description="CLI managed container (domain, standalone server, profile or managed group) where to execute the cli script", calculated=true)
    private CliManagedContainer container;
    @StepParameter(description="List of python library scripts that should be automatically loaded when using a JBoss CLI script. Usage of additional script libraries is discouraged, please use proper Python modules.", required=false, calculated=true)
    private List<String> additionalLibraries = new ArrayList<String>();
    @StepParameter(description="If true, artifacts from the python context will be uploaded to the target host and available to the script as <bindingName>.file (of type OverthereFile). Defaults to true. If set to false it will prevent staging.")
    private Boolean uploadArtifactsInPythonContext = true;
    private BaseStep cliStep;

    @RulePostConstruct
    public void doPostConstruct(StepPostConstructContext ctx) {
        super.doPostConstruct(ctx);
        this.pythonContext = ContextHelper.defaultContext((StepPostConstructContext)ctx, this.pythonContext);
        this.container = this.calculateTargetContainer(ctx);
        this.cliStep = new CliDeploymentStep(this.script, this.getOrder(), this.pythonContext, this.getDescription(), this.container);
        this.cliStep.setAdditionalLibraries(this.additionalLibraries);
    }

    private CliManagedContainer calculateTargetContainer(StepPostConstructContext ctx) {
        CliManagedContainer targetcontainer = this.container;
        if (null == targetcontainer) {
            targetcontainer = (CliManagedContainer)TargetContainerJavaHelper.defaultTargetContainer((StepPostConstructContext)ctx, CliManagedContainer.class);
        }
        return targetcontainer;
    }

    public Preview getPreview() {
        return this.cliStep.getPreview();
    }

    public void requestStaging(StagingContext ctx) {
        if (!this.uploadArtifactsInPythonContext.booleanValue()) {
            return;
        }
        HashMap<CallSite, StagedFile> stagedEntries = new HashMap<CallSite, StagedFile>();
        for (Map.Entry<String, Object> entry : this.pythonContext.entrySet()) {
            Object entryVal = entry.getValue();
            if (!(entryVal instanceof Artifact)) continue;
            Artifact artifact = (Artifact)entryVal;
            StagedFile stagedFile = ctx.stageArtifact(artifact, (StagingTarget)this.container.getHost());
            stagedEntries.put((CallSite)((Object)(entry.getKey() + "_stagedFile")), stagedFile);
        }
        this.pythonContext.putAll(stagedEntries);
    }

    public StepExitCode execute(ExecutionContext ctx) throws Exception {
        StepExitCode exitCode = StepExitCode.FAIL;
        if (this.uploadArtifactsInPythonContext.booleanValue()) {
            this.uploadArtifacts();
        }
        exitCode = this.cliStep.execute(ctx);
        return exitCode;
    }

    private void uploadArtifacts() {
        TreeSet<String> sortedKeys = new TreeSet<String>(this.pythonContext.keySet());
        for (String varName : sortedKeys) {
            Object varValue = this.pythonContext.get(varName);
            if (!(varValue instanceof Artifact)) continue;
            this.markArtifactForUpload(varName, (Artifact)varValue);
        }
    }

    private void markArtifactForUpload(String varName, Artifact artifact) {
        logger.debug("Converting variable [{}]", (Object)varName);
        if (!this.uploadArtifactsInPythonContext.booleanValue()) {
            logger.debug("Property 'file' of [{}] will NOT be automatically uploaded and adjusted to point to a remote overthere file.", (Object)varName);
            return;
        }
        String stagedFileVarName = varName + "_stagedFile";
        this.pythonContext.put(stagedFileVarName + AUTO_UPLOAD, Boolean.TRUE);
        if (this.pythonContext.containsKey(stagedFileVarName)) {
            return;
        }
        JustInTimeFile file = new JustInTimeFile(artifact);
        this.pythonContext.put(stagedFileVarName, file);
    }
}

