/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.jbossdm.step;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.StagedFile;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JustInTimeFile
implements StagedFile {
    private static final Logger logger = LoggerFactory.getLogger(JustInTimeFile.class);
    private Artifact source;

    JustInTimeFile(Artifact artifact) {
        this.source = artifact;
    }

    public OverthereFile get(OverthereConnection c, ExecutionContext ctx) {
        logger.debug("Creating temporary file for artifact [{}]", (Object)this.source.getName());
        String name = this.source.getFile().getName();
        OverthereFile uploadedFileArtifact = c.getTempFile(this.source.getFile().getName());
        ctx.logOutput(String.format("Uploading artifact [%s]", uploadedFileArtifact.getPath()));
        this.source.getFile().copyTo(uploadedFileArtifact);
        logger.debug("Uploaded artifact [{}]", (Object)uploadedFileArtifact.getPath());
        return uploadedFileArtifact;
    }
}

