/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.jbossdm.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class TimedoutInputStreamReader
extends InputStreamReader {
    private int readTimeout;
    private ExecutorService executor = Executors.newFixedThreadPool(1);

    public TimedoutInputStreamReader(InputStream in, int readTimeout) {
        super(in);
        this.readTimeout = readTimeout;
    }

    @Override
    public int read() throws IOException {
        if (this.readTimeout > 0) {
            return this.tryRead();
        }
        return super.read();
    }

    private int tryRead() throws IOException {
        Future<Integer> future = this.executor.submit(() -> super.read());
        try {
            return future.get(this.readTimeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException ex) {
            throw new IOException("Input stream read timeout");
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }
}

