<?xml version="1.0" encoding="UTF-8"?>
<datasources>
    <${deployed.dsType}>
    <#list deployed.parameters as dsp>
        <#if (dsp == "xaDatasourceProperties")>
          <#assign dsProps=deployed.xaDatasourceProperties />
          <#list dsProps?keys as dsProp>
                <xa-datasource-property name="${dsProp}">${dsProps[dsProp]?string}</xa-datasource-property>
          </#list>
        <#elseif (dsp == "connectionProperties")>
          <#assign dsProps=deployed.connectionProperties />
          <#list dsProps?keys as dsProp>
                <connection-property name="${dsProp}">${dsProps[dsProp]?string}</connection-property>
          </#list>
        <#else>
          <#-- With the recent changes XLD will return all properties of deployed (including container and deployed) as parameters.
               Previously we only had to deal with synthetic properties.
               We cannot rely on synthetic properites anymore - we should iterate over explicit list of valid datasource properties.
           -->
          <#if (deployed[dsp]?has_content) && !(deployed[dsp]?is_enumerable) && (deployed[dsp]?is_string || deployed[dsp]?is_number || deployed[dsp]?is_date || deployed[dsp]?is_boolean)>
            <#assign lh=deployed.toLowerHyphen(dsp)>
            <${lh}>${deployed[dsp]?string}</${lh}>
          </#if>
        </#if>
    </#list>
    <#-- This extention mechanism will be deprecated -->
    <#list deployed.parametersProperties as pp>
        <${pp.node} name="${pp.attribute}">${pp.value}</${pp.node}>
    </#list>
    </${deployed.dsType}>
</datasources>
