package com.xebialabs.deployit.plugin.jbossas.step;

import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.jbossas.deployed.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Collections;
import java.util.List;
import java.util.Map;

@SuppressWarnings("serial")
public class TwiddleResourceInspectionStep<D extends Deployable> extends TwiddleStep implements Step {

    final Resource<D> deployedResource;

    private final String ciProperty;
    private final Map<String, Object> vars;


    public TwiddleResourceInspectionStep(Resource<D> deployedJBossResource, String ciProperty) {
        super(deployedJBossResource.getContainer(), deployedJBossResource.getInspectTemplate());
        this.deployedResource = deployedJBossResource;
        this.ciProperty = ciProperty;
        vars = Collections.singletonMap("deployed", (Object) deployedResource);
    }

    @Override
    public int getOrder() {
        return 50;
    }

    public String getDescription() {
        return "Inspect " + deployedResource.getName();
    }

    @Override
    protected void doHandle(TwiddleProcessOutputHandler handler) {
        List<String> values = handler.getValues();
        if (values.size() > 1) {
            throw new RuntimeException("Too many answers (" + values.size() + ")" + values);
        }
        deployedResource.setProperty(ciProperty, values.iterator().next());
    }

    @Override
    protected Map<String, Object> getVars() {
        return vars;
    }

    @Override
    protected Logger logger() {
        return logger;
    }

    private static final Logger logger = LoggerFactory.getLogger(TwiddleResourceInspectionStep.class);
}
