package com.xebialabs.deployit.plugin.jbossas.deployed;

import java.util.Collection;
import java.util.TreeSet;

import com.google.common.base.CaseFormat;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Sets;

import com.xebialabs.deployit.plugin.api.inspection.Inspect;
import com.xebialabs.deployit.plugin.api.inspection.InspectionContext;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.generic.deployed.ProcessedTemplate;
import com.xebialabs.deployit.plugin.jbossas.step.TwiddleResourceInspectionStep;

@SuppressWarnings("serial")
@Metadata(virtual = true)
public class Resource<D extends Deployable> extends ProcessedTemplate<D> {

    @Inspect
    public void inspect(InspectionContext ctx) {
        ctx.addStep(new TwiddleResourceInspectionStep<D>(this, "jndiName"));
    }

    public String toLowerHyphen(String s) {
        return CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_HYPHEN, s);
    }

    public String toUpperCamel(String s) {
        return CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, s);
    }


    @Override
    public String getTemplate() {
        //TODO: push it back to generic container.
        return resolveExpression(super.getTemplate());
    }


    public String getInspectTemplate() {
        String inspectTemplate = getProperty("inspectTemplate");
        return resolveExpression(inspectTemplate);
    }


    public Collection<String> getParameters() {
        final Descriptor descriptor = DescriptorRegistry.getDescriptor(type);
        return Sets.newTreeSet(FluentIterable.from(getType().getDescriptor().getPropertyDescriptors()).filter(new Predicate<PropertyDescriptor>() {
            public boolean apply(PropertyDescriptor pd) {
                return !pd.isHidden() && !pd.getName().contains("_");
            }
        }).transform(new Function<PropertyDescriptor, String>() {
            @Override
            public String apply(PropertyDescriptor input) {
                return input.getName();
            }
        }));
    }

    /**
     * Handle generic parameters which are transfered directly to the underlying resources or driver:
     * Synthetic: <property name="connectionProperty_charEncoding" default="UTF-8" />
     * XML: <connectionProperty name="char.encoding">UTF-8</connectionProperty> />
     *
     * @return
     */
    public Collection<ParameterProperty> getParametersProperties() {
        final Descriptor descriptor = DescriptorRegistry.getDescriptor(type);
        TreeSet<String> filtered = Sets.newTreeSet(FluentIterable.from(getType().getDescriptor().getPropertyDescriptors()).filter(new Predicate<PropertyDescriptor>() {
            public boolean apply(PropertyDescriptor propertyName) {
                return !propertyName.isHidden() && propertyName.getName().contains("_");
            }
        }).transform(new Function<PropertyDescriptor, String>() {
            @Override
            public String apply(PropertyDescriptor input) {
                return input.getName();
            }
        }));
        return Collections2.transform(filtered, new Function<String, ParameterProperty>() {
            public ParameterProperty apply(String propertyName) {
                String[] split = propertyName.split("_");
                if (split.length != 2)
                    throw new RuntimeException("Cannot decode " + propertyName);
                String node = toLowerHyphen(split[0]);
                String attribute = toLowerHyphen(split[1]).replace('-', '.');
                Object value = getProperty(propertyName);
                return new ParameterProperty(node, attribute, value);
            }
        });
    }

    public class ParameterProperty {
        final String node;
        final String attribute;
        final Object value;

        public ParameterProperty(String node, String attribute, Object value) {
            this.node = node;
            this.attribute = attribute;
            this.value = value;
        }

        public String getNode() {
            return node;
        }

        public String getAttribute() {
            return attribute;
        }

        public Object getValue() {
            return value;
        }
    }


}
