/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.jbossas.step;

import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.jbossas.deployed.Resource;
import com.xebialabs.deployit.plugin.jbossas.step.TwiddleProcessOutputHandler;
import com.xebialabs.deployit.plugin.jbossas.step.TwiddleStep;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class TwiddleResourceInspectionStep<D extends Deployable>
extends TwiddleStep
implements Step {
    final Resource<D> deployedResource;
    private final String ciProperty;
    private final Map<String, Object> vars;

    public TwiddleResourceInspectionStep(Resource<D> deployedJBossResource, String ciProperty) {
        super((HostContainer)deployedJBossResource.getContainer(), deployedJBossResource.getInspectTemplate());
        this.deployedResource = deployedJBossResource;
        this.ciProperty = ciProperty;
        this.vars = Collections.singletonMap("deployed", this.deployedResource);
    }

    public int getOrder() {
        return 50;
    }

    public String getDescription() {
        return "Inspect " + this.deployedResource.getName();
    }

    @Override
    protected void doHandle(TwiddleProcessOutputHandler handler) {
        List<String> values = handler.getValues();
        if (values.size() > 1) {
            throw new RuntimeException("Too many answers (" + values.size() + ")" + values);
        }
        this.deployedResource.setProperty(this.ciProperty, values.iterator().next());
    }

    @Override
    protected Map<String, Object> getVars() {
        return this.vars;
    }
}

