/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.jbossas.step;

import com.xebialabs.deployit.plugin.api.inspection.InspectionStep;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.jbossas.deployed.Resource;
import com.xebialabs.deployit.plugin.jbossas.step.TwiddleProcessOutputHandler;
import com.xebialabs.deployit.plugin.jbossas.step.TwiddleStep;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class TwiddleResourceInspectionStep<D extends Deployable>
extends TwiddleStep
implements InspectionStep {
    final Resource<D> deployedResource;
    private final String ciProperty;
    private final Map<String, Object> vars;

    public TwiddleResourceInspectionStep(Resource<D> resource, String string) {
        super((HostContainer)resource.getContainer(), resource.getInspectTemplate());
        this.deployedResource = resource;
        this.ciProperty = string;
        this.vars = Collections.singletonMap("deployed", this.deployedResource);
    }

    public String getDescription() {
        return "Inspect " + this.deployedResource.getName();
    }

    @Override
    protected void doHandle(TwiddleProcessOutputHandler twiddleProcessOutputHandler) {
        List<String> list = twiddleProcessOutputHandler.getValues();
        if (list.size() > 1) {
            throw new RuntimeException("Too many answers (" + list.size() + ")" + list);
        }
        this.deployedResource.setProperty(this.ciProperty, list.iterator().next());
    }

    @Override
    protected Map<String, Object> getVars() {
        return this.vars;
    }
}

