package com.xebialabs.deployit.plugin.jbossas.step;

import java.util.List;
import java.util.Map;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.inspection.InspectionStep;
import com.xebialabs.deployit.plugin.overthere.HostContainer;

@SuppressWarnings("serial")
public class TwiddleContainerInspectionStep<T> extends TwiddleStep implements InspectionStep {


	private final Map<String, Object> vars = Maps.newHashMap();
	private final PropertyConverter<?> converter;

	public TwiddleContainerInspectionStep(HostContainer deployedJBossResource, String mbean, String attribute, PropertyConverter<?> converter) {
		super(deployedJBossResource, (String) deployedJBossResource.getProperty("inspectTemplate"));
		this.converter = converter;
		vars.put("container", getContainer());
		vars.put("mbean", mbean);
		vars.put("attribute", attribute);
	}

	public String getDescription() {
		return String.format("Inspect JBoss Server %s/%s", vars.get("mbean"), vars.get("attribute"));
	}

	@Override
	protected Map<String, Object> getVars() {
		return vars;
	}


	@Override
	protected void doHandle(TwiddleProcessOutputHandler handler) {
		List<String> values = handler.getValues();
		if (values.size() > 1) {
			throw new RuntimeException("Too many answers (" + values.size() + ")" + values);
		}
		Object propertyInspectedValue = converter.getConverter().apply(values.iterator().next());
		
		getContainer().setProperty(converter.getProperty(), propertyInspectedValue);
	}


}
