package com.xebialabs.deployit.plugin.jbossas.container.v6;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.xebialabs.deployit.plugin.api.inspection.Inspect;
import com.xebialabs.deployit.plugin.api.inspection.InspectionPlanningContext;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.jbossas.container.BaseServer;
import com.xebialabs.deployit.plugin.jbossas.step.SimplePropertyConverter;
import com.xebialabs.deployit.plugin.jbossas.step.TwiddleContainerInspectionStep;
import com.xebialabs.deployit.plugin.jbossas.step.TwiddleQueryConnectorContainerInspectionStep;


@SuppressWarnings("serial")
@Metadata(description = "JBoss 6.x Server")
public class Server extends BaseServer {
	
	@Property(hidden=true, defaultValue="hornetq-jms.xml")
	protected String resourceFileSuffix;
	
	static final Function<String, String> DECODE_JBOSS_HOME = new Function<String, String>() {
		public String apply(String input) {
			return input.substring(input.indexOf(":") + 1);
		}
	};

	@Inspect
	public void inspect(InspectionPlanningContext ctx) {
		ctx.addStep(new TwiddleContainerInspectionStep<String>(this, "jboss.system:type=ServerConfig", "JBossHome", new SimplePropertyConverter<String>("home", Functions.<String>identity())));
		ctx.addStep(new TwiddleContainerInspectionStep<String>(this, "jboss.system:type=ServerConfig", "ServerName", new SimplePropertyConverter<String>("serverName", Functions.<String>identity())));
		ctx.addStep(new TwiddleContainerInspectionStep<Integer>(this, "jboss.system:type=Server", "VersionNumber", new SimplePropertyConverter<Integer>("version", DECODE_VERSION)));
		ctx.addStep(new TwiddleQueryConnectorContainerInspectionStep<Object>(this,"jboss.web:type=Connector,*"));
	}

}