#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

# Get provided website name or use the deployed name.
$websiteName = if($deployed.websiteName) { $deployed.websiteName } else { $deployed.name }

# Start website, if it exists and has not already been started.
$websitePath = "IIS:\Sites\$websiteName"
if (!(Test-Path $websitePath)) {
    Write-Host "Website [$websiteName] does not exist."
    Exit 1
} elseif((Get-Item $websitePath).State -eq "Started") {
    Write-Host "Website [$websiteName] has already been started."
} else {
    Write-Host "Starting website [$websiteName]."
    Start-Website -Name $websiteName | Out-Null
}
