Function inspectVirtualDirectory($website, $vd) {
    $vdName = $vd.path.substring(1)
    $id = $container.id + "/" + $vdName
    discovered $id $prototype.type
    inspectedProperty $id "physicalPath" $vd.physicalPath
    inspectedProperty $id "websiteName" $website

    inspectDirectoryBrowsing $id "IIS:\Sites\$website\$vdName"

    inspectedItem $id

    inspectAuthentication $id "IIS:\Sites\$website\$vdName"
}

$websites = Get-Website
if($websites) {
    foreach ($ws in $websites) {
        $virtualDirs = Get-WebVirtualDirectory -Site $ws.name
        if ($virtualDirs) {
            if ($virtualDirs -is [system.array]) {
                foreach ($vd in $virtualDirs) {
                    inspectVirtualDirectory $ws.name $vd
                }
            } else {
                inspectVirtualDirectory $ws.name $virtualDirs
            }
        }
    }
}
