# Get provided application pool name or use the deployed name.
$applicationPoolName = if($deployed.applicationPoolName) { $deployed.applicationPoolName } else { $deployed.name }

# Stop application pool, if it exists.
$appPool = Get-WmiObject -Namespace "ROOT\MicrosoftIISv2" -Class IIsApplicationPool -Filter "Name ='W3SVC/APPPOOLS/$applicationPoolName'"
if($appPool) {
    Write-Host "Stopping application pool [$applicationPoolName]."
    $appPool.Stop()
} else {
    Write-Host "Application pool [$applicationPoolName] does not exist."
    Exit 1
}


