# Get provided virtual directory path or use the deployed name.
$virtualDirectoryPath = if($deployed.virtualDirectoryPath) { $deployed.virtualDirectoryPath } else { $deployed.name }

# Destroy virtual directory, if it exists.
$virtDirPath = "IIS:\Sites\$($deployed.websiteName)\$virtualDirectoryPath"
if (Test-Path $virtDirPath) {
    Write-Host "Destroying virtual directory [$virtualDirectoryPath] in website [$($deployed.websiteName)]."
    Remove-Item $virtDirPath -Recurse -Force | Out-Null
} else {
    Write-Host "Virtual directory [$virtualDirectoryPath] in website [$($deployed.websiteName)] has already been destroyed."
}
