# Get provided application pool name or use the deployed name.
$applicationPoolName = if($deployed.applicationPoolName) { $deployed.applicationPoolName } else { $deployed.name }

# Stop application pool, if it exists and has not already been stopped.
$appplicationPoolPath = "IIS:\AppPools\$applicationPoolName"
if (!(Test-Path $appplicationPoolPath)) {
    Write-Host "Application pool [$applicationPoolName] does not exist."
    Exit 1
} elseif((Get-Item $appplicationPoolPath).State -eq "Stopped") {
    Write-Host "Application pool [$applicationPoolName] has already been stopped."
} else {
    Write-Host "Stopping application pool [$applicationPoolName]."
    Stop-WebAppPool -Name $applicationPoolName -ErrorAction SilentlyContinue | Out-Null
}
