Function findPhysicalPathForWebsite($website) {
    $iis = [ADSI]"IIS://localhost/W3SVC"
    $site = $iis.psbase.children | where { $_.keyType -eq "IIsWebServer" -AND $_.ServerComment -eq $website }
    $path = [adsi]($site.psbase.path+"/ROOT")
    return $path.path
}

$virtualDirsAndTheirDotNetVersion = getDotNetVersionForVirtualDirectories $container.dotNetFrameworkInstallationPath

$websites = Get-WmiObject -Namespace "ROOT\MicrosoftIISv2" -Class "IIsWebServerSetting"
if($websites) {
    foreach ($website in $websites) {
        $id = "$($container.id)/$($website.servercomment)"
        discovered $id $prototype.type
        $physicalPath = findPhysicalPathForWebsite($website.servercomment)
        inspectedProperty $id "physicalPath" $physicalPath
    
        $appPool = $website.appPoolId
        if ($appPool -ne "DefaultAppPool") {
            inspectedProperty $id "applicationPoolName" $appPool
        }
    
        $websiteVirtualDirectory = "$($website.Name)/Root/".toLower()
        $dotNetVersion = $virtualDirsAndTheirDotNetVersion[$websiteVirtualDirectory]
        inspectedProperty $id "dotNetVersion" $dotNetVersion
    
        inspectedItem $id
        
        foreach ($binding in $website.ServerBindings) {
            $port = $binding.Port
            $ipAddress = if($binding.IP) { $binding.IP } else { "*" }
            $hostHeader = if($binding.Hostname) { $binding.Hostname } else { "" }
    
            $bid = "$id/http_$($ipAddress -replace "[:*]", "_")_$($port)_$hostHeader"
            discovered $bid "iis.WebsiteBinding"
    
            inspectedProperty $bid "protocol" "http"
            inspectedProperty $bid "ipAddress" $ipAddress
            inspectedProperty $bid "port" $port
            inspectedProperty $bid "hostHeader" $hostHeader
    
            inspectedItem $bid
        }
    }
}

