# Get provided website name or use the deployed name.
$websiteName = if($deployed.websiteName) { $deployed.websiteName } else { $deployed.name }

# Start website, if it exists.
$webServerSetting = getWebsite $websiteName
if ($webServerSetting) {
    Write-Output "Starting website [$websiteName]."
    $webServers = Get-WmiObject -Namespace 'ROOT\MicrosoftIISv2' -Class IIsWebServer
    $targetServer = $webServers | Where-Object { $_.Name -eq $webServerSetting.Name }
    $targetServer.Start()
} else {
    Write-Output "Website [$websiteName] does not exist and will not be started."
}
