$applicationPath = if($deployed.applicationPath) { $deployed.applicationPath } else { $deployed.name }

if (!(Test-Path $deployed.physicalPath)) {
	Write-Output "Creating empty application physical path [$($deployed.physicalPath)]"
	if(!(New-Item $deployed.physicalPath -Type Directory -Force)) {
        Write-Error "Cannot create directory [$($deployed.physicalPath)]"
        Exit 1
	}
}

Write-Output "Creating application [$applicationPath] in website [$($deployed.websiteName)]"
$newApplication = New-Item "IIS:\Sites\$($deployed.websiteName)\$applicationPath" -Type Application -PhysicalPath $deployed.physicalPath
Set-ItemProperty -path $newApplication.PSPath -name enabledProtocols -value $deployed.protocols
if($deployed.applicationPoolName) {
	Set-ItemProperty -path $newApplication.PSPath -name applicationPool -value $deployed.applicationPoolName
}
