$virtualDirectoryPath = if($deployed.virtualDirectoryPath) { $deployed.virtualDirectoryPath } else { $deployed.name }

if (!(Test-Path $deployed.physicalPath)) {
    Write-Output "Creating virtual directory physical path [$($deployed.physicalPath)]"
    if(!(New-Item $deployed.physicalPath -Type Directory -Force)) {
        Write-Error "Cannot create directory [$($deployed.physicalPath)]"
        Exit 1
    }
}

Write-Output "Creating virtual directory [$virtualDirectoryPath] in website [$($deployed.websiteName)]"
New-Item "IIS:\Sites\$($deployed.websiteName)\$virtualDirectoryPath" -Type VirtualDirectory -PhysicalPath $deployed.physicalPath | Out-Null
