#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

# Get provided virtual directory path or use the deployed name.
$virtualDirectoryPath = if($deployed.virtualDirectoryPath) { $deployed.virtualDirectoryPath } else { $deployed.name }

# Verify website exists.
$website = getWebsite $deployed.websiteName
if (!$website) {
    Write-Host "Website [$($deployed.websiteName)] has already been destroyed."
    return
}

# Destroy virtual directory, if it exists.
$virtualDirectory = getVirtualDirectory $website $virtualDirectoryPath
if ($virtualDirectory) {
    Write-Host "Destroying virtual directory [$virtualDirectoryPath] in website [$($deployed.websiteName)]."
    $virtualDirectory.DeleteTree()
} else {
    Write-Host "Virtual directory [$virtualDirectoryPath] in website [$($deployed.websiteName)] has already been destroyed."
}
