#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

# Get provided application pool name or use the deployed name.
$applicationPoolName = if($deployed.applicationPoolName) { $deployed.applicationPoolName } else { $deployed.name }

# Start application pool, if it exists and has not already been started.
$applicationPoolPath = "IIS:\AppPools\$applicationPoolName"
if (!(Test-Path $applicationPoolPath)) {
    Write-Host "Application pool [$applicationPoolName] does not exist."
    Exit 1
} elseif((Get-Item $applicationPoolPath).State -eq "Started") {
    Write-Host "Application pool [$applicationPoolName] has already been started."
} else {
    Write-Host "Starting application pool [$applicationPoolName]."
    Start-WebAppPool -Name $applicationPoolName | Out-Null
    # Start-WebAppPool is aysnchronous, need to verify if appPool is actually started
    $currentRetry = 1;
    $success = $false;
    do {
        $status = (Get-Item $applicationPoolPath).State
        if ($status -eq "Started"){
            Write-Host "Application pool [$applicationPoolName] has started."
                $success = $true;
        }
        Start-Sleep -s $deployed.sleepBetweenChecks
        $currentRetry = $currentRetry + 1;
    }
    while (!$success -and $currentRetry -le $deployed.numberOfChecks)
    if ($currentRetry -eq $deployed.numberOfChecks -And $success -eq $false) {
        Write-Host "Application pool [$applicationPoolName] is still not started. Please retry."
        Exit 1
    }
}
