#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

# Get provided website name or use the deployed name.
$websiteName = if($deployed.websiteName) { $deployed.websiteName } else { $deployed.name }

# Stop website, if it exists.
$webServerSetting = getWebsite $websiteName
if ($webServerSetting) {
    Write-Host "Stopping website [$websiteName]."
    $webServers = Get-WmiObject -Namespace 'ROOT\MicrosoftIISv2' -Class IIsWebServer
    $targetServer = $webServers | Where-Object { $_.Name -eq $webServerSetting.Name }
    $targetServer.Stop()
} else {
    Write-Host "Website [$websiteName] does not exist."
    Exit 1
}
