#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

# Get provided application path or use the deployed name.
$applicationPath = if($deployed.applicationPath) { $deployed.applicationPath } else { $deployed.name }

# Verify website exists.
$website = getWebsite $deployed.websiteName
if (!$website) {
    Write-Host "Website [$($deployed.websiteName)] has already been destroyed."
    return
}

# Destroy application, if it exists.
$application = getVirtualDirectory $website $applicationPath
if ($application) {
    Write-Host "Destroying application [$applicationPath] in website [$($deployed.websiteName)]."
    $application.DeleteTree()
} else {
    Write-Host "Application [$applicationPath] in website [$($deployed.websiteName)] has already been destroyed."
}
