#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#
Write-Host "Create ConfigCollectionElement started"

if($previousDeployed -ne $null -and $previousDeployed.attributes -ne $null -and $previousDeployed.attributes -ne ""){
    Write-Host "Previous Deployed not empty"
    $previousAttributes = $previousDeployed.attributes
} else {
    Write-Host "Previous Deployed empty"
    $previousAttributes = $deployed.attributes
}

#Construct previous attribute values in format required for Get-WebConfigurationProperty
$array = @()
$prevAttrMap = @{}
$attrList = $previousAttributes.split([Environment]::NewLine)

Foreach ($attr IN $attrList) {
    if ($attr.Contains("~")) {
        $tokens = $attr.split("~")
        $array +=  ("[" + $($tokens[0]) + "='" + $($tokens[1]) + "']")
        $prevAttrMap.add($tokens[0],$tokens[1])
    }
}

$prevAttrFormatted = "Collection" + [string]::Join(",",$array)

#Get CollectionElement if already exists
if($deployed.psPath -ne $null -and $deployed.location -ne $null) {
    Write-Host "Command executed to Get WebConfigurationProperty -Filter $deployed.filter -PSPath $deployed.psPath -Location $deployed.location -Name $prevAttrFormatted"
    $collectionElement = Get-WebConfigurationProperty -Filter $deployed.filter -PSPath $deployed.psPath -Location $deployed.location -Name $prevAttrFormatted
} elseif ($deployed.psPath -ne $null) {
    Write-Host "Command executed to Get WebConfigurationProperty -Filter $deployed.filter -PSPath $deployed.psPath -Name $prevAttrFormatted"
    $collectionElement = Get-WebConfigurationProperty -Filter $deployed.filter -PSPath $deployed.psPath -Name $prevAttrFormatted
} elseif ($deployed.location -ne $null) {
    Write-Host "Command executed to Get WebConfigurationProperty -Filter $deployed.filter -Location $deployed.location -Name $prevAttrFormatted"
    $collectionElement = Get-WebConfigurationProperty -Filter $deployed.filter -Location $deployed.location -Name $prevAttrFormatted
} else {
    Write-Host "Command executed to Get WebConfigurationProperty -Filter $deployed.filter -Name $prevAttrFormatted"
    $collectionElement = Get-WebConfigurationProperty -Filter $deployed.filter -Name $prevAttrFormatted
}

#Construct new attribute values in format required for Set|Add-WebConfigurationProperty
$attrMap = @{}
$attrList = $deployed.attributes.split([Environment]::NewLine)
Foreach ($attr IN $attrList) {
    if ($attr.Contains("~")) {
        $tokens = $attr.split("~")
        $attrMap.add($tokens[0],$tokens[1])
    }
}

# Write-Host "User Input -Filter $deployed.filter -PSPath $deployed.psPath -Location $deployed.location -AtIndex $deployed.atIndex -Name . -Value attrMap"
if($collectionElement -eq $null) {
    Write-Host "CollectionElement does not exist, Creating element"
     if($deployed.psPath -ne $null -and $deployed.location -ne $null -and $deployed.atIndex -ne $null) {
         Write-Host "Command executed to Add WebConfigurationProperty -Filter $deployed.filter -PSPath $deployed.psPath -Location $deployed.location -AtIndex $deployed.atIndex -Name . -Value $attrMap"
         $collectionElement = Add-WebConfigurationProperty -Filter $deployed.filter -PSPath $deployed.psPath -Location $deployed.location -AtIndex $deployed.atIndex -Name . -Value $attrMap
     } elseif ($deployed.psPath -ne $null -and $deployed.atIndex -ne $null) {
         Write-Host "Command executed to Add WebConfigurationProperty -Filter $deployed.filter -PSPath $deployed.psPath -AtIndex $deployed.atIndex -Name . -Value $attrMap"
         $collectionElement = Add-WebConfigurationProperty -Filter $deployed.filter -PSPath $deployed.psPath -AtIndex $deployed.atIndex -Name . -Value $attrMap
     } elseif ($deployed.location -ne $null -and $deployed.atIndex -ne $null) {
         Write-Host "Command executed to Add WebConfigurationProperty -Filter $deployed.filter -Location $deployed.location -AtIndex $deployed.atIndex -Name . -Value $attrMap"
         $collectionElement = Add-WebConfigurationProperty -Filter $deployed.filter -Location $deployed.location -AtIndex $deployed.atIndex -Name . -Value $attrMap
     } elseif ($deployed.psPath -ne $null -and $deployed.location -ne $null) {
         Write-Host "Command executed to Add WebConfigurationProperty -Filter $deployed.filter -PSPath $deployed.psPath -Location $deployed.location -Name . -Value $attrMap"
         $collectionElement = Add-WebConfigurationProperty -Filter $deployed.filter -PSPath $deployed.psPath -Location $deployed.location -Name . -Value $attrMap
     } elseif ($deployed.psPath -ne $null) {
         Write-Host "Command executed to Add WebConfigurationProperty -Filter $deployed.filter -PSPath $deployed.psPath -Name . -Value $attrMap"
         $collectionElement = Add-WebConfigurationProperty -Filter $deployed.filter -PSPath $deployed.psPath -Name . -Value $attrMap
     } elseif ($deployed.location -ne $null) {
         Write-Host "Command executed to Add WebConfigurationProperty -Filter $deployed.filter -Location $deployed.location -Name . -Value $attrMap"
         $collectionElement = Add-WebConfigurationProperty -Filter $deployed.filter -Location $deployed.location -Name . -Value $attrMap
     } elseif ($deployed.atIndex -ne $null) {
         Write-Host "Command executed to Add WebConfigurationProperty -Filter $deployed.filter -AtIndex $deployed.atIndex $atIndex -Name . -Value $attrMap"
         $collectionElement = Add-WebConfigurationProperty -Filter $deployed.filter -AtIndex $deployed.atIndex $atIndex -Name . -Value $attrMap
     } else {
         Write-Host "Command executed to Add WebConfigurationProperty -Filter $deployed.filter -Name . -Value $attrMap"
         $collectionElement = Add-WebConfigurationProperty -Filter $deployed.filter -Name . -Value $attrMap
     }
} else {
    Write-Host "CollectionElement already exists, Updating element"
    if($deployed.psPath -ne $null -and $deployed.location -ne $null) {
        Write-Host "Command executed to Set WebConfigurationProperty -Filter $deployed.filter -PSPath $deployed.psPath -Location $deployed.location -Name . -Value $attrMap -AtElement $prevAttrMap"
        $collectionElement = Set-WebConfigurationProperty -Filter $deployed.filter -PSPath $deployed.psPath -Location $deployed.location -Name . -Value $attrMap -AtElement $prevAttrMap
    } elseif ($psPath -ne $null) {
        Write-Host "Command executed to Set WebConfigurationProperty -Filter $deployed.filter -PSPath $deployed.psPath -Name . -Value $attrMap -AtElement $prevAttrMap"
        $collectionElement = Set-WebConfigurationProperty -Filter $deployed.filter -PSPath $deployed.psPath -Name . -Value $attrMap -AtElement $prevAttrMap
    } elseif ($location -ne $null) {
        Write-Host "Command executed to Set WebConfigurationProperty -Filter $deployed.filter -Location $deployed.location -Name . -Value $attrMap -AtElement $prevAttrMap"
        $collectionElement = Set-WebConfigurationProperty -Filter $deployed.filter -Location $deployed.location -Name . -Value $attrMap -AtElement $prevAttrMap
    } else {
        Write-Host "Command executed to Set WebConfigurationProperty -Filter $deployed.filter -Name . -Value $attrMap -AtElement $prevAttrMap"
        $collectionElement = Set-WebConfigurationProperty -Filter $deployed.filter -Name . -Value $attrMap -AtElement $prevAttrMap
    }
}
Write-Host "Create ConfigCollectionElement completed"
